/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AbstractExampleTable;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.RandomDataRowReader;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomExampleTable
extends AbstractExampleTable {
    private static final long serialVersionUID = 5675878166499224680L;
    private ExampleSet baseExampleSet;
    private int size;

    public RandomExampleTable(ExampleSet baseExampleSet, List<Attribute> attributes, int size) {
        super(attributes);
        this.baseExampleSet = baseExampleSet;
        this.size = size;
    }

    @Override
    public DataRowReader getDataRowReader() {
        return new RandomDataRowReader(this.baseExampleSet, this.getAttributes(), this.size);
    }

    @Override
    public DataRow getDataRow(int index) {
        RandomGenerator random = RandomGenerator.getRandomGenerator(-1);
        double[] data = new double[this.size];
        int i = 0;
        while (i < data.length) {
            double min = this.baseExampleSet.getStatistics(this.getAttributes()[i], "minimum");
            double max = this.baseExampleSet.getStatistics(this.getAttributes()[i], "maximum");
            data[i] = random.nextDoubleInRange(min, max);
            ++i;
        }
        return new DoubleArrayDataRow(data);
    }

    @Override
    public int size() {
        return this.size;
    }
}

