/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.extraction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.FeatureExtractor;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTool;
import edu.udo.cs.wvtool.util.WVToolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLengthExtractor
implements FeatureExtractor {
    WVTool wvtool = new WVTool(true);
    WVTConfiguration config = new WVTConfiguration();
    Attribute lengthAttribute = AttributeFactory.createAttribute("file_length", 2);

    @Override
    public void extract(WVTDocumentInfo info, DataRow dr) throws ExtractionException {
        double length = 0.0;
        try {
            BufferedReader in = new BufferedReader(this.wvtool.getReader(info, this.config));
            String buf = null;
            while ((buf = in.readLine()) != null) {
                length += (double)buf.length();
            }
            in.close();
        }
        catch (WVToolException e) {
            length = Double.NaN;
        }
        catch (IOException e) {
            length = Double.NaN;
        }
        dr.set(this.lengthAttribute, length);
    }

    @Override
    public Collection<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(1);
        attributes.add(this.lengthAttribute);
        return attributes;
    }
}

