/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.GnuPlotDataTableHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GNUPlotOperator
extends Operator {
    public static final String PARAMETER_OUTPUT_FILE = "output_file";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_TITLE = "title";
    public static final String PARAMETER_X_AXIS = "x_axis";
    public static final String PARAMETER_Y_AXIS = "y_axis";
    public static final String PARAMETER_VALUES = "values";
    public static final String PARAMETER_ADDITIONAL_PARAMETERS = "additional_parameters";

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    public GNUPlotOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String dataTableName = this.getParameterAsString(PARAMETER_NAME);
        if (!this.getProcess().dataTableExists(dataTableName)) {
            this.logError("Data table with name '" + dataTableName + "' does not exist.");
            return new IOObject[0];
        }
        DataTable dataTable = this.getProcess().getDataTable(dataTableName);
        String[] valueNames = this.getParameterAsString(PARAMETER_VALUES).split(" ");
        int[] values = new int[valueNames.length];
        int i = 0;
        while (i < values.length) {
            values[i] = dataTable.getColumnIndex(valueNames[i]);
            if (values[i] == -1) {
                this.logError(String.valueOf(this.getName()) + ": No data column with name '" + valueNames[i] + "' exists.");
                return new IOObject[0];
            }
            ++i;
        }
        String xAxisName = this.getParameterAsString(PARAMETER_X_AXIS);
        int xAxis = dataTable.getColumnIndex(xAxisName);
        if (xAxis == -1) {
            this.logError("No data column with name '" + xAxisName + "' exists.");
            return new IOObject[0];
        }
        String yAxisName = this.getParameterAsString(PARAMETER_Y_AXIS);
        int yAxis = -1;
        if (yAxisName != null && (yAxis = dataTable.getColumnIndex(yAxisName)) == -1) {
            this.logError("No data column with name '" + yAxisName + "' exists.");
            return new IOObject[0];
        }
        String additional = "";
        if (this.isParameterSet(PARAMETER_TITLE)) {
            additional = String.valueOf(additional) + "set title \"" + this.getParameterAsString(PARAMETER_TITLE) + "\"" + Tools.getLineSeparator();
        }
        if (this.isParameterSet(PARAMETER_ADDITIONAL_PARAMETERS)) {
            additional = String.valueOf(additional) + this.getParameterAsString(PARAMETER_ADDITIONAL_PARAMETERS);
        }
        File file = this.getParameterAsFile(PARAMETER_OUTPUT_FILE, true);
        this.log("Creating gnuplot file '" + file + "'");
        PrintStream out = null;
        try {
            try {
                out = new PrintStream(new FileOutputStream(file));
                GnuPlotDataTableHandler handler = new GnuPlotDataTableHandler(dataTable);
                handler.writeGNUPlot(out, xAxis, yAxis, values, "linespoints", additional, null);
            }
            catch (IOException e) {
                this.logError("Cannot create output file: " + e.getMessage());
                IOObject[] iOObjectArray = new IOObject[]{};
                if (out != null) {
                    out.close();
                }
                return iOObjectArray;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return new IOObject[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_OUTPUT_FILE, "The gnuplot file.", "gnu", false));
        types.add(new ParameterTypeString(PARAMETER_NAME, "The name of the process log operator which produced the data table.", false));
        types.add(new ParameterTypeString(PARAMETER_TITLE, "The title of the plot.", "Created by RapidMiner"));
        types.add(new ParameterTypeString(PARAMETER_X_AXIS, "The values of the x-axis.", false));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_Y_AXIS, "The values of the y-axis (for 3d plots).", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_VALUES, "A whitespace separated list of values which should be plotted.", false));
        types.add(new ParameterTypeString(PARAMETER_ADDITIONAL_PARAMETERS, "Additional parameters for the gnuplot header.", true));
        return types;
    }
}

