/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.utility;

import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.igss.utility.Coverage;
import com.rapidminer.operator.learner.igss.utility.InstanceAveraging;

public class WRAcc
extends InstanceAveraging {
    public WRAcc(double[] priors, int large) {
        super(priors, large);
    }

    public double utility(double totalWeight, double totalPositiveWeight, Hypothesis hypo) {
        double g = hypo.getCoveredWeight() / totalWeight;
        double p = hypo.getPositiveWeight() / hypo.getCoveredWeight();
        if (hypo.getPrediction() == 1) {
            return g * (p - this.priors[1]);
        }
        return g * (p - this.priors[0]);
    }

    public double variance(double totalWeight, double totalPositiveWeight, Hypothesis hypo) {
        double p0 = hypo.getPrediction() == 1 ? this.priors[1] : this.priors[0];
        double mean = this.utility(totalWeight, totalPositiveWeight, hypo);
        double innerTerm = hypo.getPositiveWeight() * Math.pow(1.0 - p0 - mean, 2.0) + (hypo.getCoveredWeight() - hypo.getPositiveWeight()) * Math.pow(0.0 - p0 - mean, 2.0) + (totalWeight - hypo.getCoveredWeight()) * Math.pow(0.0 - mean, 2.0);
        return Math.sqrt(innerTerm) / totalWeight;
    }

    public double getUpperBound(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        double p0 = hypo.getPrediction() == 1 ? this.priors[1] : this.priors[0];
        Coverage cov = new Coverage(this.priors, this.large);
        Hypothesis h = hypo.clone();
        h.setCoveredWeight(hypo.getPositiveWeight());
        double g = cov.utility(totalWeight, totalPositiveWeight, h);
        double conf = cov.confidenceIntervall(totalWeight, delta);
        return (g + conf) * (1.0 - p0);
    }
}

