/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.subgroups;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.viewer.RuleSetVisualization;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.SimplePredictionModel;
import com.rapidminer.operator.learner.subgroups.hypothesis.Rule;
import com.rapidminer.operator.learner.subgroups.utility.UtilityFunction;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSet
extends SimplePredictionModel
implements Iterable<Rule> {
    private boolean predictUncoveredRules = false;
    private static final long serialVersionUID = -47885282272818733L;
    private LinkedList<Rule> rules = new LinkedList();
    private LinkedHashSet<UtilityFunction> utilityFunctions = new LinkedHashSet();

    public RuleSet(ExampleSet exampleSet) {
        super(exampleSet);
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
        this.utilityFunctions.addAll(rule.getUtilityFunctions());
    }

    public Rule getRule(int index) {
        return this.rules.get(index);
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.rules.iterator();
    }

    public LinkedList<Rule> getPositiveRules() {
        LinkedList<Rule> positiveRules = new LinkedList<Rule>();
        for (Rule rule : this) {
            if (!rule.predictsPositive()) continue;
            positiveRules.add(rule);
        }
        return positiveRules;
    }

    public LinkedList<Rule> getNegativeRules() {
        LinkedList<Rule> negativeRules = new LinkedList<Rule>();
        for (Rule rule : this) {
            if (rule.predictsPositive()) continue;
            negativeRules.add(rule);
        }
        return negativeRules;
    }

    public int size() {
        return this.getNumberOfRules();
    }

    @Override
    public double predict(Example example) throws OperatorException {
        for (Rule rule : this.rules) {
            if (!rule.applicable(example)) continue;
            return rule.getPrediction();
        }
        return this.predictUncoveredRules ? (double)example.getAttributes().getLabel().getMapping().getNegativeIndex() : Double.NaN;
    }

    public UtilityFunction[] getUtilityFunctions() {
        UtilityFunction[] functions = new UtilityFunction[this.utilityFunctions.size()];
        functions = this.utilityFunctions.toArray(functions);
        return functions;
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        return new RuleSetVisualization(this, super.getVisualizationComponent(container));
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        for (Rule rule : this.rules) {
            if (i < 10) {
                stringBuffer.append(rule.toStringScored());
                stringBuffer.append(Tools.getLineSeparator());
            }
            ++i;
        }
        if (i > 10) {
            stringBuffer.append(Tools.getLineSeparators(2));
            stringBuffer.append("... and " + (i - 10) + " more rules!");
        }
        return stringBuffer.toString();
    }
}

