/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.weka;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.weka.GenericWekaLearner;
import com.rapidminer.operator.learner.weka.WekaClassifier;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.WekaLearnerCapabilities;
import com.rapidminer.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnassignedClassException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWekaMetaLearner
extends OperatorChain
implements Learner,
TechnicalInformationHandler {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{Model.class};
    public static final String[] WEKA_CLASSIFIERS = WekaTools.getWekaClasses(Classifier.class, ".meta.", true);
    private List<ParameterType> wekaParameters = new LinkedList<ParameterType>();

    public GenericWekaMetaLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Model model = this.learn(exampleSet);
        return new IOObject[]{model};
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        String[] wekaParas = this.getWekaParameters();
        if (wekaParas == null) {
            throw new UserError((Operator)this, 131, "simple Weka learner");
        }
        Classifier classifier = this.getWekaClassifier(wekaParas);
        this.log("Converting to Weka instances.");
        Instances instances = WekaTools.toWekaInstances(exampleSet, "MetaLearningInstances", 0);
        try {
            this.log("Building Weka classifier.");
            classifier.buildClassifier(instances);
        }
        catch (UnassignedClassException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, new Object[]{this.getOperatorClassName(), e});
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, this.getOperatorClassName(), e);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, this.getOperatorClassName(), e);
        }
        return new WekaClassifier(exampleSet, this.getOperatorClassName(), classifier);
    }

    public String getWekaClassPath() {
        String prefixName = this.getOperatorClassName();
        String actualName = prefixName.substring("W-".length());
        int i = 0;
        while (i < WEKA_CLASSIFIERS.length) {
            if (WEKA_CLASSIFIERS[i].endsWith(actualName)) {
                return WEKA_CLASSIFIERS[i];
            }
            ++i;
        }
        return null;
    }

    public List getWekaParameterList() {
        return this.wekaParameters;
    }

    private Classifier getWekaClassifier(String[] parameters) throws OperatorException {
        String classifierName = this.getWekaClassPath();
        Classifier classifier = null;
        try {
            Class<?> clazz = Class.forName(classifierName);
            classifier = (Classifier)clazz.newInstance();
            if (parameters != null && classifier instanceof OptionHandler) {
                ((OptionHandler)classifier).setOptions(parameters);
            }
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, classifierName, e);
        }
        return classifier;
    }

    public TechnicalInformation getTechnicalInformation() {
        try {
            Classifier classifier = this.getWekaClassifier(null);
            if (classifier instanceof TechnicalInformationHandler) {
                return ((TechnicalInformationHandler)classifier).getTechnicalInformation();
            }
            return null;
        }
        catch (OperatorException e) {
            return null;
        }
    }

    private String[] getWekaParameters() throws OperatorException {
        String[] parameters = WekaTools.getWekaParametersFromTypes(this, this.wekaParameters);
        Operator operator = this.getOperator(0);
        if (operator instanceof GenericWekaLearner) {
            GenericWekaLearner inner = (GenericWekaLearner)operator;
            String[] innerParameters = WekaTools.getWekaParametersFromTypes(inner, inner.getWekaParameterList());
            int n = 0;
            int totalNumber = parameters.length + innerParameters.length + 3;
            String[] result = new String[totalNumber];
            int i = 0;
            while (i < parameters.length) {
                result[n++] = parameters[i];
                ++i;
            }
            result[n++] = "-W";
            result[n++] = inner.getWekaClassPath();
            result[n++] = "--";
            i = 0;
            while (i < innerParameters.length) {
                result[n++] = innerParameters[i];
                ++i;
            }
            return result;
        }
        throw new UserError((Operator)this, 127, "Inner operator of a Weka ensemble learning operator '" + this.getName() + "' must be another Weka learning scheme.");
    }

    public boolean onlyWarnForNonSufficientCapabilities() {
        return true;
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        Classifier classifier;
        try {
            classifier = this.getWekaClassifier(WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        }
        catch (OperatorException e) {
            return true;
        }
        if (classifier != null) {
            try {
                return WekaLearnerCapabilities.supportsCapability(classifier, capability);
            }
            catch (Throwable t) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return false;
    }

    @Override
    public boolean shouldCalculateWeights() {
        return false;
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "estimation of performance not supported.");
    }

    @Override
    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), "calculation of weights not supported.");
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{Model.class});
    }

    @Override
    public void performAdditionalChecks() throws UserError {
        super.performAdditionalChecks();
        if (!(this.getOperator(0) instanceof GenericWekaLearner)) {
            throw new UserError((Operator)this, 127, "Inner operator of a Weka meta learning operator '" + this.getName() + "' must be another Weka learning scheme.");
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Classifier classifier = null;
        try {
            classifier = this.getWekaClassifier(null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka classifier " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList<ParameterType>();
        if (classifier != null && classifier instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)classifier, types, this.wekaParameters, true, "W");
        }
        return types;
    }
}

