/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.condition.AllInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueIteration
extends OperatorChain {
    public static final String PARAMETER_ATTRIBUTE = "attribute";
    public static final String PARAMETER_ITERATION_MACRO = "iteration_macro";
    public static final String DEFAULT_ITERATION_MACRO_NAME = "loop_value";
    private String currentValue = null;

    public ValueIteration(OperatorDescription description) {
        super(description);
        this.addValue(new ValueString("current_value", "The nominal value of the current loop."){

            public String getStringValue() {
                return ValueIteration.this.currentValue;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        exampleSet.recalculateAllAttributeStatistics();
        IOContainer innerResult = new IOContainer(new IOObject[0]);
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE);
        Attribute attribute = exampleSet.getAttributes().get(attributeName);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 119, attributeName, this.getName());
        }
        String iterationMacro = this.getParameterAsString(PARAMETER_ITERATION_MACRO);
        List<String> values = attribute.getMapping().getValues();
        for (String value : values) {
            if (exampleSet.getStatistics(attribute, "count", value) > 0.0) {
                if (iterationMacro != null) {
                    this.getProcess().getMacroHandler().addMacro(iterationMacro, value);
                }
                this.currentValue = value;
                IOContainer input = new IOContainer((ExampleSet)exampleSet.clone());
                Iterator<Operator> opIt = this.getOperators();
                while (opIt.hasNext()) {
                    try {
                        input = opIt.next().apply(input);
                    }
                    catch (ConcurrentModificationException e) {
                        if (this.isDebugMode()) {
                            e.printStackTrace();
                        }
                        throw new UserError(this, 923);
                    }
                }
                int k = 0;
                while (k < input.size()) {
                    input.getElementAt(k).setSource(String.valueOf(this.getName()) + ":" + value);
                    ++k;
                }
                innerResult = innerResult.append(input.getIOObjects());
            }
            this.inApplyLoop();
        }
        if (iterationMacro != null) {
            this.getProcess().getMacroHandler().addMacro(iterationMacro, null);
        }
        return innerResult.getIOObjects();
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[0]);
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        Iterator<Operator> i = this.getOperators();
        Operator current = null;
        while (i.hasNext()) {
            current = i.next();
        }
        if (current != null) {
            return current.getOutputClasses();
        }
        return new Class[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString(PARAMETER_ATTRIBUTE, "The nominal attribute for which the iteration should be defined", false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_ITERATION_MACRO, "Name of macro which is set in each iteration.", DEFAULT_ITERATION_MACRO_NAME));
        return types;
    }
}

