/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.tools.RandomGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoiseOperator
extends AbstractDataProcessing {
    public static final String PARAMETER_RANDOM_ATTRIBUTES = "random_attributes";
    public static final String PARAMETER_LABEL_NOISE = "label_noise";
    public static final String PARAMETER_DEFAULT_ATTRIBUTE_NOISE = "default_attribute_noise";
    public static final String PARAMETER_NOISE = "noise";
    public static final String PARAMETER_OFFSET = "offset";
    public static final String PARAMETER_LINEAR_FACTOR = "linear_factor";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public NoiseOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        HashMap<String, Double> noiseMap = new HashMap<String, Double>();
        List<String[]> noises = this.getParameterList(PARAMETER_NOISE);
        for (String[] pair : noises) {
            noiseMap.put(pair[0], Double.valueOf(pair[1]));
        }
        double defaultAttributeNoise = this.getParameterAsDouble(PARAMETER_DEFAULT_ATTRIBUTE_NOISE);
        double labelNoise = this.getParameterAsDouble(PARAMETER_LABEL_NOISE);
        Iterator reader = exampleSet.iterator();
        Attribute label = exampleSet.getAttributes().getLabel();
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!attribute.isNumerical()) continue;
                Double noiseObject = (Double)noiseMap.get(attribute.getName());
                double noise = noiseObject == null ? defaultAttributeNoise : noiseObject;
                double noiseValue = random.nextGaussian() * noise;
                example.setValue(attribute, example.getValue(attribute) + noiseValue);
            }
            if (label != null) {
                if (label.isNumerical()) {
                    double min = exampleSet.getStatistics(label, "minimum");
                    double max = exampleSet.getStatistics(label, "maximum");
                    double labelRange = Math.abs(max - min);
                    double noiseValue = random.nextGaussian() * labelNoise * labelRange;
                    example.setValue(label, example.getValue(label) + noiseValue);
                } else if (label.isNominal() && label.getMapping().size() >= 2 && random.nextDouble() < labelNoise) {
                    int oldValue;
                    int newValue = oldValue = (int)example.getValue(label);
                    while (newValue == oldValue) {
                        newValue = random.nextInt(label.getMapping().size());
                    }
                    example.setValue(label, newValue);
                }
            }
            this.checkForStop();
        }
        int numberOfNewAttributes = this.getParameterAsInt(PARAMETER_RANDOM_ATTRIBUTES);
        double offset = this.getParameterAsDouble(PARAMETER_OFFSET);
        double linearFactor = this.getParameterAsDouble(PARAMETER_LINEAR_FACTOR);
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        int j = 0;
        while (j < numberOfNewAttributes) {
            Attribute newAttribute = AttributeFactory.createAttribute(AttributeFactory.createName("random"), 4);
            newAttributes.add(newAttribute);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
            ++j;
        }
        for (Example example : exampleSet) {
            Iterator a = newAttributes.iterator();
            while (a.hasNext()) {
                example.setValue((Attribute)a.next(), offset + linearFactor * random.nextGaussian());
            }
            this.checkForStop();
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_RANDOM_ATTRIBUTES, "Adds this number of random attributes.", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_LABEL_NOISE, "Add this percentage of a numerical label range as a normal distributed noise or probability for a nominal label change.", 0.0, Double.POSITIVE_INFINITY, 0.05);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_DEFAULT_ATTRIBUTE_NOISE, "The standard deviation of the default attribute noise.", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeList(PARAMETER_NOISE, "List of noises for each attributes.", new ParameterTypeDouble(PARAMETER_NOISE, "Names of attributes and noises to use.", 0.0, Double.POSITIVE_INFINITY, 0.05)));
        type = new ParameterTypeDouble(PARAMETER_OFFSET, "Offset added to the values of each random attribute", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_LINEAR_FACTOR, "Linear factor multiplicated with the values of each random attribute", 0.0, Double.POSITIVE_INFINITY, 1.0);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

