/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.text;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.text.TextObject;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextObjectWriter
extends Operator {
    private static final String PARAMETER_FILE = "file";
    private static final String PARAMETER_OVERWRITE = "overwrite";

    public TextObjectWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        TextObject text = this.getInput(TextObject.class);
        File targetFile = this.getParameterAsFile(PARAMETER_FILE, true);
        if (targetFile.exists() && this.getParameterAsBoolean(PARAMETER_OVERWRITE)) {
            targetFile.delete();
        }
        if (!targetFile.exists()) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile));
                writer.write(text.getText());
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new IOObject[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameters = super.getParameterTypes();
        parameters.add(new ParameterTypeFile(PARAMETER_FILE, "Specifies the file, the text will be written into.", "*", false));
        parameters.add(new ParameterTypeBoolean(PARAMETER_OVERWRITE, "Specifies if an existing file with given name should be overwritten.", true));
        return parameters;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{TextObject.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }
}

