/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tokenizer;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.TokenSequence;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermNGramGenerator
extends Operator {
    public static final String PARAMETER_MAX_LENGTH = "max_length";

    public TermNGramGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        TokenSequence sequence = this.getInput(TokenSequence.class);
        LinkedList<String> ngrams = new LinkedList<String>();
        ArrayList<String> tokenList = new ArrayList<String>(sequence.getTokenSequence());
        int k = 1;
        try {
            k = this.getParameterAsInt(PARAMETER_MAX_LENGTH);
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        int i = 0;
        while (i < tokenList.size()) {
            int j = 0;
            while (j < k) {
                StringBuffer s = new StringBuffer();
                if (i + j < tokenList.size()) {
                    int z = i;
                    while (z < i + j + 1) {
                        s.append((String)tokenList.get(z));
                        if (z != i + j) {
                            s.append('_');
                        }
                        ++z;
                    }
                }
                if (s.length() > 0) {
                    ngrams.add(s.toString());
                }
                ++j;
            }
            ++i;
        }
        return new IOObject[]{new TokenSequence(ngrams, sequence.getDocumentInfo())};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{TokenSequence.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{TokenSequence.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_MAX_LENGTH, "The maximal length of the ngrams.", 1, Integer.MAX_VALUE, 2));
        return types;
    }
}

