/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.Tools;
import com.rapidminer.operator.validation.ValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBootstrappingValidation
extends ValidationChain {
    public static final String PARAMETER_NUMBER_OF_VALIDATIONS = "number_of_validations";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_AVERAGE_PERFORMANCES_ONLY = "average_performances_only";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private int number;
    private int iteration;

    public AbstractBootstrappingValidation(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return AbstractBootstrappingValidation.this.iteration;
            }
        });
    }

    protected abstract int[] createMapping(ExampleSet var1, int var2, Random var3) throws OperatorException;

    @Override
    public IOObject[] estimatePerformance(ExampleSet inputSet) throws OperatorException {
        this.number = this.getParameterAsInt(PARAMETER_NUMBER_OF_VALIDATIONS);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        ArrayList<AverageVector> averageVectors = new ArrayList<AverageVector>();
        this.iteration = 0;
        while (this.iteration < this.number) {
            int[] mapping = this.createMapping(inputSet, (int)Math.round((double)inputSet.size() * this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO)), random);
            MappedExampleSet trainingSet = new MappedExampleSet((ExampleSet)inputSet.clone(), mapping, true);
            this.learn(trainingSet);
            MappedExampleSet inverseExampleSet = new MappedExampleSet((ExampleSet)inputSet.clone(), mapping, false);
            IOContainer evalOutput = this.evaluate(inverseExampleSet);
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY));
            this.inApplyLoop();
            ++this.iteration;
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        if (averagePerformance != null) {
            this.setResult(averagePerformance);
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_OF_VALIDATIONS, "Number of subsets for the crossvalidation.", 2, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "This ratio of examples will be sampled (with replacement) in each iteration.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY, "Indicates if only performance vectors should be averaged or all types of averagable result vectors.", true));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

