/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.learner.FormulaProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaExtractor
extends Operator {
    public FormulaExtractor(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Model model = this.getInput(Model.class);
        if (model instanceof FormulaProvider) {
            return new IOObject[]{model, new FormulaResult(((FormulaProvider)model).getFormula())};
        }
        this.logWarning("The model is not capable of producing formulas, formula will be empty...");
        return new IOObject[]{model, new FormulaResult("Model is not capable of producing formulas.")};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{Model.class, FormulaResult.class};
    }

    private static class FormulaResult
    extends ResultObjectAdapter {
        private static final long serialVersionUID = 4106026192882970425L;
        private String formula;

        public FormulaResult(String formula) {
            this.formula = formula;
        }

        public String getName() {
            return "Formula";
        }

        public String getExtension() {
            return ".for";
        }

        public String getFileDescription() {
            return "formula file";
        }

        public String toString() {
            return this.formula;
        }
    }
}

