/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.math.MathFunctions;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationMatrixOperator
extends Operator {
    public static final String PARAMETER_CREATE_WEIGHTS = "create_weights";
    public static final String PARAMETER_NORMALIZE_WEIGHTS = "normalize_weights";
    public static final String PARAMETER_SQUARED_CORRELATION = "squared_correlation";

    public CorrelationMatrixOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        NumericalMatrix matrix = new NumericalMatrix("Correlation", exampleSet, true);
        int numberOfAttributes = exampleSet.getAttributes().size();
        boolean squared = this.getParameterAsBoolean(PARAMETER_SQUARED_CORRELATION);
        boolean createWeights = this.getParameterAsBoolean(PARAMETER_CREATE_WEIGHTS);
        boolean normalizeWeights = this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS);
        int k = 0;
        for (Attribute firstAttribute : exampleSet.getAttributes()) {
            int l = 0;
            for (Attribute secondAttribute : exampleSet.getAttributes()) {
                matrix.setValue(k, l, MathFunctions.correlation(exampleSet, firstAttribute, secondAttribute, squared || createWeights));
                this.checkForStop();
                ++l;
            }
            ++k;
        }
        if (createWeights) {
            AttributeWeights weights = new AttributeWeights();
            int i = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double sum = 0.0;
                int j = 0;
                while (j < numberOfAttributes) {
                    sum += 1.0 - matrix.getValue(i, j);
                    ++j;
                }
                weights.setWeight(attribute.getName(), sum / (double)numberOfAttributes);
                ++i;
            }
            if (normalizeWeights) {
                weights.normalize();
            }
            return new IOObject[]{exampleSet, weights};
        }
        return new IOObject[]{exampleSet, matrix};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        Class[] classArray;
        if (this.getParameterAsBoolean(PARAMETER_CREATE_WEIGHTS)) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = ExampleSet.class;
            classArray = classArray2;
            classArray2[1] = AttributeWeights.class;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = ExampleSet.class;
            classArray = classArray3;
            classArray3[1] = NumericalMatrix.class;
        }
        return classArray;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_CREATE_WEIGHTS, "Indicates if attribute weights based on correlation should be calculated or if the complete matrix should be returned.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE_WEIGHTS, "Indicates if the attributes weights should be normalized.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_SQUARED_CORRELATION, "Indicates if the squared correlation should be calculated.", false));
        return types;
    }
}

