/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.DriverAdapter;
import java.sql.Driver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverInfo
implements Comparable<DriverInfo> {
    private Driver driver;
    private String shortName;
    private String longName;

    public DriverInfo(Driver driver) {
        this.driver = driver;
        this.shortName = driver instanceof DriverAdapter ? driver.toString() : Tools.classNameWOPackage(driver.getClass());
        this.longName = driver instanceof DriverAdapter ? ((DriverAdapter)driver).toLongString() : driver.getClass().getName();
    }

    public DriverInfo(String shortName) {
        this(shortName, null);
    }

    public DriverInfo(String shortName, String longName) {
        this.driver = null;
        this.shortName = shortName;
        this.longName = longName;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getClassName() {
        return this.longName;
    }

    public String toString() {
        return String.valueOf(this.getShortName()) + " (" + this.getClassName() + ")";
    }

    @Override
    public int compareTo(DriverInfo o) {
        return this.getShortName().compareTo(o.getShortName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof DriverInfo)) {
            return false;
        }
        DriverInfo a = (DriverInfo)o;
        return this.getShortName().equals(a.getShortName());
    }

    public int hashCode() {
        return this.getShortName().hashCode();
    }
}

