/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class MinFunction
extends AbstractAggregationFunction {
    private double minValue;

    public MinFunction() {
        this(true);
    }

    public MinFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    public String getName() {
        return "minimum";
    }

    protected void reset() {
        this.foundMissing = false;
        this.minValue = Double.POSITIVE_INFINITY;
    }

    public void update(double value, double weight) {
        this.update(value);
    }

    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        if (value < this.minValue) {
            this.minValue = value;
        }
    }

    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        return this.minValue;
    }

    public boolean supportsAttribute(Attribute attribute) {
        return !attribute.isNominal();
    }
}

