/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.math.kernels.AnovaKernel;
import com.rapidminer.tools.math.kernels.DotKernel;
import com.rapidminer.tools.math.kernels.EpanechnikovKernel;
import com.rapidminer.tools.math.kernels.FullCache;
import com.rapidminer.tools.math.kernels.GaussianCombinationKernel;
import com.rapidminer.tools.math.kernels.KernelCache;
import com.rapidminer.tools.math.kernels.MapBasedCache;
import com.rapidminer.tools.math.kernels.MultiquadricKernel;
import com.rapidminer.tools.math.kernels.PolynomialKernel;
import com.rapidminer.tools.math.kernels.RBFKernel;
import com.rapidminer.tools.math.kernels.SigmoidKernel;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Kernel
implements Serializable {
    private static final long serialVersionUID = 581189377433816413L;
    public static final String PARAMETER_KERNEL_TYPE = "kernel_type";
    public static final String PARAMETER_KERNEL_GAMMA = "kernel_gamma";
    public static final String PARAMETER_KERNEL_SIGMA1 = "kernel_sigma1";
    public static final String PARAMETER_KERNEL_SIGMA2 = "kernel_sigma2";
    public static final String PARAMETER_KERNEL_SIGMA3 = "kernel_sigma3";
    public static final String PARAMETER_KERNEL_DEGREE = "kernel_degree";
    public static final String PARAMETER_KERNEL_SHIFT = "kernel_shift";
    public static final String PARAMETER_KERNEL_A = "kernel_a";
    public static final String PARAMETER_KERNEL_B = "kernel_b";
    public static final String[] KERNEL_TYPES = new String[]{"dot", "radial", "polynomial", "sigmoid", "anova", "epanechnikov", "gausian_combination", "multiquadric"};
    public static final int KERNEL_DOT = 0;
    public static final int KERNEL_RADIAL = 1;
    public static final int KERNEL_POLYNOMIAL = 2;
    public static final int KERNEL_SIGMOID = 3;
    public static final int KERNEL_ANOVA = 4;
    public static final int KERNEL_EPANECHNIKOV = 5;
    public static final int KERNEL_GAUSSIAN_COMBINATION = 6;
    public static final int KERNEL_MULTIQUADRIC = 7;
    private KernelCache cache;
    private ExampleSet exampleSet;

    public abstract int getType();

    public abstract double calculateDistance(double[] var1, double[] var2);

    public abstract String getDistanceFormula(double[] var1, String[] var2);

    public void init(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
        int exampleSetSize = exampleSet.size();
        this.cache = exampleSetSize < 8000 ? new FullCache(exampleSet, this) : new MapBasedCache(exampleSetSize);
    }

    public double getDistance(int x1, int x2) {
        double result = this.cache.get(x1, x2);
        if (Double.isNaN(result)) {
            result = this.calculateDistance(this.getAttributeValues(x1), this.getAttributeValues(x2));
            this.cache.store(x1, x2, result);
        }
        return result;
    }

    public double[] getAttributeValues(int i) {
        Example example = this.exampleSet.getExample(i);
        double[] values = new double[this.exampleSet.getAttributes().size()];
        int x = 0;
        for (Attribute attribute : this.exampleSet.getAttributes()) {
            values[x++] = example.getValue(attribute);
        }
        return values;
    }

    public double innerProduct(double[] x1, double[] x2) {
        double result = 0.0;
        int i = 0;
        while (i < x1.length) {
            result += x1[i] * x2[i];
            ++i;
        }
        return result;
    }

    public double norm2(double[] x1, double[] x2) {
        double result = 0.0;
        int i = 0;
        while (i < x1.length) {
            double factor = x1[i] - x2[i];
            result += factor * factor;
            ++i;
        }
        return result;
    }

    public double getSum(Collection supportVectors, double[] currentX) {
        double sum = 0.0;
        for (SupportVector sv : supportVectors) {
            sum += sv.getY() * sv.getAlpha() * this.calculateDistance(sv.getX(), currentX);
        }
        return sum;
    }

    public static Kernel createKernel(ParameterHandler handler) throws UndefinedParameterError {
        int kernelType = handler.getParameterAsInt(PARAMETER_KERNEL_TYPE);
        if (kernelType == 0) {
            return new DotKernel();
        }
        if (kernelType == 1) {
            RBFKernel kernel = new RBFKernel();
            kernel.setGamma(handler.getParameterAsDouble(PARAMETER_KERNEL_GAMMA));
            return kernel;
        }
        if (kernelType == 2) {
            PolynomialKernel kernel = new PolynomialKernel();
            kernel.setPolynomialParameters(handler.getParameterAsDouble(PARAMETER_KERNEL_DEGREE), handler.getParameterAsDouble(PARAMETER_KERNEL_SHIFT));
            return kernel;
        }
        if (kernelType == 3) {
            SigmoidKernel kernel = new SigmoidKernel();
            kernel.setSigmoidParameters(handler.getParameterAsDouble(PARAMETER_KERNEL_A), handler.getParameterAsDouble(PARAMETER_KERNEL_B));
            return kernel;
        }
        if (kernelType == 4) {
            AnovaKernel kernel = new AnovaKernel();
            kernel.setGamma(handler.getParameterAsDouble(PARAMETER_KERNEL_GAMMA));
            kernel.setDegree(handler.getParameterAsDouble(PARAMETER_KERNEL_DEGREE));
            return kernel;
        }
        if (kernelType == 5) {
            EpanechnikovKernel kernel = new EpanechnikovKernel();
            kernel.setSigma(handler.getParameterAsDouble(PARAMETER_KERNEL_SIGMA1));
            kernel.setDegree(handler.getParameterAsDouble(PARAMETER_KERNEL_DEGREE));
            return kernel;
        }
        if (kernelType == 6) {
            GaussianCombinationKernel kernel = new GaussianCombinationKernel();
            kernel.setSigma1(handler.getParameterAsDouble(PARAMETER_KERNEL_SIGMA1));
            kernel.setSigma2(handler.getParameterAsDouble(PARAMETER_KERNEL_SIGMA2));
            kernel.setSigma3(handler.getParameterAsDouble(PARAMETER_KERNEL_SIGMA3));
            return kernel;
        }
        if (kernelType == 7) {
            MultiquadricKernel kernel = new MultiquadricKernel();
            kernel.setSigma(handler.getParameterAsDouble(PARAMETER_KERNEL_SIGMA1));
            kernel.setShift(handler.getParameterAsDouble(PARAMETER_KERNEL_SHIFT));
            return kernel;
        }
        return null;
    }

    public static Collection<ParameterType> getParameters(ParameterHandler parameterHandler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_KERNEL_TYPE, "The kernel type", KERNEL_TYPES, 1);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_GAMMA, "The kernel parameter gamma.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_KERNEL_TYPE, false, 1, 4));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA1, "The kernel parameter sigma1.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_KERNEL_TYPE, false, 5, 6, 7));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA2, "The kernel parameter sigma2.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_KERNEL_TYPE, false, 6));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA3, "The kernel parameter sigma3.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_KERNEL_TYPE, false, 6));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_DEGREE, "The kernel parameter degree.", 0.0, Double.POSITIVE_INFINITY, 3.0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_KERNEL_TYPE, false, 2, 4, 5));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SHIFT, "The kernel parameter shift.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_KERNEL_TYPE, false, 2, 7));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_A, "The kernel parameter a.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_KERNEL_TYPE, false, 3));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_B, "The kernel parameter b.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(parameterHandler, PARAMETER_KERNEL_TYPE, false, 3));
        types.add(type);
        return types;
    }
}

