/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.IOException;
import marytts.signalproc.analysis.CepstrumLPCAnalyser;
import marytts.util.data.ESTTrackReader;
import marytts.util.data.ESTTrackWriter;

public class Lpc2Lpcc {
    private static float[][] convertData(float[][] lpc, int cepstrumOrder) {
        int nLPC = lpc[0].length;
        double gain = 0.0;
        double[] a = new double[nLPC];
        a[0] = 1.0;
        double[] c = new double[cepstrumOrder + 1];
        float[][] lpcc = new float[lpc.length][cepstrumOrder + 1];
        for (int i = 0; i < lpc.length; ++i) {
            int k;
            gain = lpc[i][0];
            for (k = 1; k < nLPC; ++k) {
                a[k] = lpc[i][k];
            }
            c = CepstrumLPCAnalyser.lpc2lpcc(a, gain, cepstrumOrder);
            for (k = 0; k <= cepstrumOrder; ++k) {
                lpcc[i][k] = (float)c[k];
            }
        }
        return lpcc;
    }

    public static void convert(String inFileName, String outFileName, int cepstrumOrder) throws IOException {
        ESTTrackReader etr = new ESTTrackReader(inFileName);
        float[][] lpcc = Lpc2Lpcc.convertData(etr.getFrames(), cepstrumOrder);
        ESTTrackWriter etw = new ESTTrackWriter(etr.getTimes(), lpcc, "lpcc");
        etw.doWriteAndClose(outFileName, etr.isBinary(), etr.isBigEndian());
    }

    public static void main(String[] args) throws IOException {
        Lpc2Lpcc.convert(args[1], args[2], new Integer(args[0]));
    }
}

