/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.AudioProcessor;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;

public class EnergyNormaliser
implements AudioProcessor {
    protected double amplitudeFactor;
    protected double referencePower;

    public EnergyNormaliser(double energyFactor) {
        this.amplitudeFactor = Math.sqrt(energyFactor);
        this.referencePower = -1.0;
    }

    public EnergyNormaliser(AudioInputStream reference) {
        this.referencePower = EnergyNormaliser.determineAveragePower(reference);
        this.amplitudeFactor = -1.0;
    }

    public EnergyNormaliser(DoubleDataSource reference) {
        this.referencePower = EnergyNormaliser.determineAveragePower(reference);
        this.amplitudeFactor = -1.0;
    }

    public double getAmplitudeFactor() {
        return this.amplitudeFactor;
    }

    public double getReferencePower() {
        return this.referencePower;
    }

    public static double determineAveragePower(AudioInputStream ais) {
        if (ais == null) {
            throw new NullPointerException("Received null argument");
        }
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        return EnergyNormaliser.determineAveragePower(signal);
    }

    public static double determineAveragePower(DoubleDataSource signal) {
        if (signal == null) {
            throw new NullPointerException("Received null argument");
        }
        double[] signalData = signal.getAllData();
        return EnergyNormaliser.determineAveragePower(signalData);
    }

    public static double determineAveragePower(double[] signal) {
        if (signal == null) {
            throw new NullPointerException("Received null argument");
        }
        if (signal.length == 0) {
            return 0.0;
        }
        double energy = MathUtils.sum(MathUtils.multiply(signal, signal));
        if (energy == 0.0 || signal.length == 0) {
            return 0.0;
        }
        return energy / (double)signal.length;
    }

    @Override
    public AudioInputStream apply(AudioInputStream ais) {
        AudioDoubleDataSource adds = new AudioDoubleDataSource(ais);
        return new DDSAudioInputStream(this.apply(adds), adds.getAudioFormat());
    }

    public DoubleDataSource apply(DoubleDataSource signal) {
        DoubleDataSource source;
        double factor;
        if (this.amplitudeFactor >= 0.0) {
            factor = this.amplitudeFactor;
            source = signal;
        } else {
            assert (this.referencePower >= 0.0);
            double[] signalData = signal.getAllData();
            double power = EnergyNormaliser.determineAveragePower(signalData);
            factor = power == 0.0 ? 0.0 : Math.sqrt(this.referencePower / power);
            source = new BufferedDoubleDataSource(signalData);
        }
        System.err.println("Applying amplitude factor: " + factor);
        return new BufferedDoubleDataSource(source, new InlineDataProcessor(){

            @Override
            public void applyInline(double[] buf, int off, int len) {
                int i = off;
                while (i < off + len) {
                    int n = i++;
                    buf[n] = buf[n] * factor;
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        double[] totalEnergies = new double[args.length];
        double[] maxAmplitude = new double[args.length];
        for (int i = 0; i < args.length; ++i) {
            double[] signal = new AudioDoubleDataSource(AudioSystem.getAudioInputStream(new File(args[i]))).getAllData();
            totalEnergies[i] = 0.0;
            for (int j = 0; j < signal.length; ++j) {
                int n = i;
                totalEnergies[n] = totalEnergies[n] + signal[j] * signal[j];
            }
            maxAmplitude[i] = MathUtils.max(signal);
            System.err.println(args[i] + ": total energy = " + totalEnergies[i] + ", max amplitude = " + maxAmplitude[i]);
        }
        double meanEnergy = MathUtils.mean(totalEnergies);
        int indexMaxAmplitude = MathUtils.findGlobalPeakLocation(maxAmplitude);
        System.err.println("Mean energy: " + meanEnergy);
        System.err.println("Highest amplitude found in " + args[indexMaxAmplitude]);
        int MAX_AMPLITUDE = Short.MAX_VALUE;
        for (int i = 0; i < args.length; ++i) {
            double energyFactor = meanEnergy / totalEnergies[i];
            System.err.println(args[i] + ": applying factor " + energyFactor + " = " + meanEnergy + " / " + totalEnergies[i]);
            if (maxAmplitude[i] * Math.sqrt(energyFactor) > (double)MAX_AMPLITUDE) {
                System.err.println("Warning: signal clipping in file " + args[i] + "_norm.wav");
            }
            EnergyNormaliser norm = new EnergyNormaliser(energyFactor);
            File f = new File(args[i]);
            AudioInputStream ais = AudioSystem.getAudioInputStream(f);
            AudioInputStream result = norm.apply(ais);
            String outFileName = args[i].substring(0, args[i].lastIndexOf(46)) + "_norm.wav";
            File outFile = new File(outFileName);
            AudioSystem.write(result, AudioFileFormat.Type.WAVE, outFile);
        }
    }
}

