/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.window;

import java.util.Arrays;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.LogSpectrum;
import marytts.signalproc.window.Window;
import marytts.util.math.MathUtils;

public class RectWindow
extends Window {
    public RectWindow(int length) {
        super(length);
    }

    public RectWindow(int length, double prescalingFactor) {
        super(length, prescalingFactor);
    }

    @Override
    protected void initialise() {
        Arrays.fill(this.window, this.prescalingFactor);
    }

    public String toString() {
        return "Rect window";
    }

    public static void main(String[] args) {
        int samplingRate = Integer.getInteger("samplingrate", 1);
        int windowLengthMs = Integer.getInteger("windowlength.ms", 0);
        int windowLength = Integer.getInteger("windowlength.samples", 512);
        if (windowLengthMs != 0) {
            windowLength = windowLengthMs * samplingRate / 1000;
        }
        int fftSize = Math.max(4096, MathUtils.closestPowerOfTwoAbove(windowLength));
        RectWindow w = new RectWindow(windowLength);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0 / (double)samplingRate, w.window);
        timeGraph.showInJFrame(((Object)w).toString() + " in time domain", true, false);
        double[] fftSignal = new double[fftSize];
        double sum = MathUtils.sum(w.window);
        for (int i = 0; i < w.window.length; ++i) {
            fftSignal[i] = w.window[i] / sum;
        }
        LogSpectrum freqGraph = new LogSpectrum(fftSignal, samplingRate);
        freqGraph.showInJFrame(((Object)w).toString() + " log frequency response", true, false);
    }
}

