/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Properties;
import marytts.exceptions.MaryConfigurationException;
import marytts.unitselection.data.MCepDatagram;
import marytts.unitselection.data.TimelineReader;
import marytts.util.data.Datagram;

public class MCepTimelineReader
extends TimelineReader {
    protected int order;

    public MCepTimelineReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    @Override
    protected void load(String fileName) throws IOException, MaryConfigurationException {
        super.load(fileName);
        Properties props = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.procHdr.getString().getBytes("latin1"));
        props.load(bais);
        this.ensurePresent(props, "mcep.order");
        this.order = Integer.parseInt(props.getProperty("mcep.order"));
    }

    private void ensurePresent(Properties props, String key) throws IOException {
        if (!props.containsKey(key)) {
            throw new IOException("Processing header does not contain required field '" + key + "'");
        }
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    protected Datagram getNextDatagram(ByteBuffer bb) {
        MCepDatagram d = null;
        if (bb.position() == this.timeIdxBytePos) {
            return null;
        }
        try {
            d = new MCepDatagram(bb, this.order);
        }
        catch (IOException e) {
            return null;
        }
        return d;
    }
}

