/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import java.util.Arrays;
import marytts.util.math.ComplexNumber;

public class ComplexArray {
    public double[] real;
    public double[] imag;

    public ComplexArray(int len) {
        this.init(len);
    }

    public ComplexArray(double[] realVals, double[] imagVals) {
        if (realVals != null && imagVals != null && realVals.length == imagVals.length) {
            this.init(realVals.length);
            System.arraycopy(realVals, 0, this.real, 0, realVals.length);
            System.arraycopy(imagVals, 0, this.imag, 0, imagVals.length);
        }
    }

    public ComplexArray(ComplexArray c) {
        this(c.real, c.imag);
    }

    public void init(int len) {
        if (len > 0) {
            this.real = new double[len];
            this.imag = new double[len];
            Arrays.fill(this.real, 0.0);
            Arrays.fill(this.imag, 0.0);
        } else {
            this.real = null;
            this.imag = null;
        }
    }

    public ComplexNumber get(int index) {
        return new ComplexNumber((float)this.real[index], (float)this.imag[index]);
    }
}

