/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.morph;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.morph.AbstractDelegatingOperation;
import net.didion.jwnl.dictionary.morph.BaseFormSet;
import net.didion.jwnl.dictionary.morph.LookupIndexWordOperation;
import net.didion.jwnl.dictionary.morph.Operation;
import net.didion.jwnl.dictionary.morph.Util;
import net.didion.jwnl.util.factory.Param;
import net.didion.jwnl.util.factory.ParamList;

public class TokenizerOperation
extends AbstractDelegatingOperation {
    public static final String TOKEN_OPERATIONS = "token_operations";
    public static final String PHRASE_OPERATIONS = "phrase_operations";
    public static final String DELIMITERS = "delimiters";
    private String[] _delimiters;

    public TokenizerOperation() {
    }

    public TokenizerOperation(String[] delimiters) {
        this._delimiters = delimiters;
    }

    protected AbstractDelegatingOperation getInstance(Map params) throws JWNLException {
        ParamList delimiters = (ParamList)params.get(DELIMITERS);
        String[] delimiterArray = null;
        if (delimiters == null || delimiters.getParams().size() == 0) {
            delimiterArray = new String[]{" "};
        } else {
            delimiterArray = new String[delimiters.getParams().size()];
            int i = 0;
            while (i < delimiters.getParams().size()) {
                delimiterArray[i] = ((Param)delimiters.getParams().get(i)).getValue();
                ++i;
            }
        }
        return new TokenizerOperation(delimiterArray);
    }

    protected String[] getKeys() {
        return new String[]{TOKEN_OPERATIONS, PHRASE_OPERATIONS};
    }

    public boolean execute(POS pos, String lemma, BaseFormSet forms) throws JWNLException {
        String[] tokens = Util.split(lemma);
        BaseFormSet[] tokenForms = new BaseFormSet[tokens.length];
        if (!this.hasDelegate(TOKEN_OPERATIONS)) {
            this.addDelegate(TOKEN_OPERATIONS, new Operation[]{new LookupIndexWordOperation()});
        }
        if (!this.hasDelegate(PHRASE_OPERATIONS)) {
            this.addDelegate(PHRASE_OPERATIONS, new Operation[]{new LookupIndexWordOperation()});
        }
        int i = 0;
        while (i < tokens.length) {
            tokenForms[i] = new BaseFormSet();
            tokenForms[i].add(tokens[i]);
            this.delegate(pos, tokens[i], tokenForms[i], TOKEN_OPERATIONS);
            ++i;
        }
        boolean foundForms = false;
        int i2 = 0;
        while (i2 < tokenForms.length) {
            int j = tokenForms.length - 1;
            while (j >= i2) {
                if (this.tryAllCombinations(pos, tokenForms, i2, j, forms)) {
                    foundForms = true;
                }
                --j;
            }
            ++i2;
        }
        return foundForms;
    }

    private boolean tryAllCombinations(POS pos, BaseFormSet[] tokenForms, int startIndex, int endIndex, BaseFormSet forms) throws JWNLException {
        int length = endIndex - startIndex + 1;
        int[] indexArray = new int[length];
        int[] endArray = new int[length];
        int i = 0;
        while (i < indexArray.length) {
            indexArray[i] = 0;
            endArray[i] = tokenForms[startIndex + i].size() - 1;
            ++i;
        }
        boolean foundForms = false;
        block1: while (true) {
            String[] tokens = new String[length];
            int i2 = 0;
            while (i2 < length) {
                tokens[i2] = tokenForms[i2 + startIndex].getForm(indexArray[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < this._delimiters.length) {
                if (this.tryAllCombinations(pos, tokens, this._delimiters[i2], forms)) {
                    foundForms = true;
                }
                ++i2;
            }
            if (Arrays.equals(indexArray, endArray)) break;
            i2 = length - 1;
            while (true) {
                if (i2 < 0) continue block1;
                if (indexArray[i2] != endArray[i2]) {
                    int n = i2;
                    indexArray[n] = indexArray[n] + 1;
                    continue block1;
                }
                indexArray[i2] = 0;
                --i2;
            }
            break;
        }
        return foundForms;
    }

    private boolean tryAllCombinations(POS pos, String[] tokens, String delimiter, BaseFormSet forms) throws JWNLException {
        BitSet bits = new BitSet();
        int size = tokens.length - 1;
        boolean foundForms = false;
        do {
            String lemma;
            if (!this.delegate(pos, lemma = Util.getLemma(tokens, bits, delimiter), forms, PHRASE_OPERATIONS)) continue;
            foundForms = true;
        } while (Util.increment(bits, size));
        return foundForms;
    }
}

