/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.cart.NodeIterator;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;

public abstract class DecisionNode
extends Node {
    protected boolean TRACE = false;
    protected FeatureDefinition featureDefinition;
    protected Node[] daughters;
    protected int featureIndex;
    protected String feature;
    protected int lastDaughter;
    protected int nData;
    protected int uniqueDecisionNodeId;

    public DecisionNode(String feature, int numDaughters, FeatureDefinition featureDefinition) {
        this.feature = feature;
        this.featureIndex = featureDefinition.getFeatureIndex(feature);
        this.daughters = new Node[numDaughters];
        this.isRoot = false;
        this.featureDefinition = featureDefinition;
    }

    public DecisionNode(int featureIndex, int numDaughters, FeatureDefinition featureDefinition) {
        this.featureIndex = featureIndex;
        this.feature = featureDefinition.getFeatureName(featureIndex);
        this.daughters = new Node[numDaughters];
        this.isRoot = false;
        this.featureDefinition = featureDefinition;
    }

    public DecisionNode(int numDaughters, FeatureDefinition featureDefinition) {
        this.daughters = new Node[numDaughters];
        this.isRoot = false;
        this.featureDefinition = featureDefinition;
    }

    @Override
    public boolean isDecisionNode() {
        return true;
    }

    public String getFeatureName() {
        return this.feature;
    }

    public int getFeatureIndex() {
        return this.featureIndex;
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.featureDefinition;
    }

    public void addDaughter(Node daughter) {
        if (this.lastDaughter > this.daughters.length - 1) {
            throw new RuntimeException("Can not add daughter number " + (this.lastDaughter + 1) + ", since node has only " + this.daughters.length + " daughters!");
        }
        this.daughters[this.lastDaughter] = daughter;
        if (daughter != null) {
            daughter.setMother(this, this.lastDaughter);
        }
        ++this.lastDaughter;
    }

    public Node getDaughter(int index) {
        if (index > this.daughters.length - 1 || index < 0) {
            return null;
        }
        return this.daughters[index];
    }

    public void replaceDaughter(Node newDaughter, int index) {
        if (index > this.daughters.length - 1 || index < 0) {
            throw new RuntimeException("Can not replace daughter number " + index + ", since daughter index goes from 0 to " + (this.daughters.length - 1) + "!");
        }
        this.daughters[index] = newDaughter;
        newDaughter.setMother(this, index);
    }

    public boolean hasMoreDaughters(int index) {
        return index > -1 && index < this.daughters.length;
    }

    @Override
    public Object getAllData() {
        Object[] result;
        LeafNode firstLeaf = (LeafNode)new NodeIterator(this, true, false, false).next();
        if (firstLeaf == null) {
            return null;
        }
        if (firstLeaf instanceof LeafNode.IntArrayLeafNode) {
            result = new int[this.nData];
        } else if (firstLeaf instanceof LeafNode.FeatureVectorLeafNode) {
            result = new FeatureVector[this.nData];
        } else {
            return null;
        }
        this.fillData(result, 0, this.nData);
        return result;
    }

    @Override
    protected void fillData(Object target, int pos, int total) {
        for (int i = 0; i < this.daughters.length; ++i) {
            if (this.daughters[i] == null) continue;
            int len = this.daughters[i].getNumberOfData();
            this.daughters[i].fillData(target, pos, len);
            pos += len;
        }
    }

    @Override
    public int getNumberOfNodes() {
        int nNodes = 1;
        for (int i = 0; i < this.daughters.length; ++i) {
            if (this.daughters[i] == null) continue;
            nNodes += this.daughters[i].getNumberOfNodes();
        }
        return nNodes;
    }

    @Override
    public int getNumberOfData() {
        return this.nData;
    }

    public int getNumberOfDaugthers() {
        return this.daughters.length;
    }

    public void countData() {
        this.nData = 0;
        for (int i = 0; i < this.daughters.length; ++i) {
            if (this.daughters[i] instanceof DecisionNode) {
                ((DecisionNode)this.daughters[i]).countData();
            }
            if (this.daughters[i] == null) continue;
            this.nData += this.daughters[i].getNumberOfData();
        }
    }

    public String toString() {
        return "dn" + this.uniqueDecisionNodeId;
    }

    public abstract String getDecisionPath(int var1);

    public void setUniqueDecisionNodeId(int id) {
        this.uniqueDecisionNodeId = id;
    }

    public int getUniqueDecisionNodeId() {
        return this.uniqueDecisionNodeId;
    }

    public abstract String getNodeDefinition();

    public abstract Type getDecisionNodeType();

    public abstract Node getNextNode(FeatureVector var1);

    public static class ShortDecisionNode
    extends DecisionNode {
        public ShortDecisionNode(String feature, int numDaughters, FeatureDefinition featureDefinition) {
            super(feature, numDaughters, featureDefinition);
        }

        public ShortDecisionNode(int featureIndex, int numDaughters, FeatureDefinition featureDefinition) {
            super(featureIndex, numDaughters, featureDefinition);
        }

        @Override
        public Node getNextNode(FeatureVector featureVector) {
            short val = featureVector.getShortFeature(this.featureIndex);
            if (this.TRACE) {
                System.out.println(this.feature + ": " + this.featureDefinition.getFeatureValueAsString(this.featureIndex, val));
            }
            return this.daughters[val];
        }

        @Override
        public String getDecisionPath(int daughterIndex) {
            String thisNodeInfo = this.feature + "==" + this.featureDefinition.getFeatureValueAsString(this.featureIndex, daughterIndex);
            if (this.mother == null) {
                return thisNodeInfo;
            }
            if (this.mother.isDecisionNode()) {
                return ((DecisionNode)this.mother).getDecisionPath(this.getNodeIndex()) + " - " + thisNodeInfo;
            }
            return this.mother.getDecisionPath() + " - " + thisNodeInfo;
        }

        @Override
        public String getNodeDefinition() {
            return this.feature + " isShortOf " + this.daughters.length;
        }

        @Override
        public Type getDecisionNodeType() {
            return Type.ShortDecisionNode;
        }
    }

    public static class ByteDecisionNode
    extends DecisionNode {
        public ByteDecisionNode(String feature, int numDaughters, FeatureDefinition featureDefinition) {
            super(feature, numDaughters, featureDefinition);
        }

        public ByteDecisionNode(int featureIndex, int numDaughters, FeatureDefinition featureDefinition) {
            super(featureIndex, numDaughters, featureDefinition);
        }

        @Override
        public Node getNextNode(FeatureVector featureVector) {
            byte val = featureVector.getByteFeature(this.featureIndex);
            if (this.TRACE) {
                System.out.println(this.feature + ": " + this.featureDefinition.getFeatureValueAsString(this.featureIndex, val));
            }
            return this.daughters[val];
        }

        @Override
        public String getDecisionPath(int daughterIndex) {
            String thisNodeInfo = this.feature + "==" + this.featureDefinition.getFeatureValueAsString(this.featureIndex, daughterIndex);
            if (this.mother == null) {
                return thisNodeInfo;
            }
            if (this.mother.isDecisionNode()) {
                return ((DecisionNode)this.mother).getDecisionPath(this.getNodeIndex()) + " - " + thisNodeInfo;
            }
            return this.mother.getDecisionPath() + " - " + thisNodeInfo;
        }

        @Override
        public String getNodeDefinition() {
            return this.feature + " isByteOf " + this.daughters.length;
        }

        @Override
        public Type getDecisionNodeType() {
            return Type.ByteDecisionNode;
        }
    }

    public static class BinaryFloatDecisionNode
    extends DecisionNode {
        private float value;
        private boolean isByteFeature;

        public BinaryFloatDecisionNode(int featureIndex, float value, FeatureDefinition featureDefinition) {
            this(featureDefinition.getFeatureName(featureIndex), value, featureDefinition);
        }

        public BinaryFloatDecisionNode(String feature, float value, FeatureDefinition featureDefinition) {
            super(feature, 2, featureDefinition);
            this.value = value;
            this.isByteFeature = featureDefinition.isByteFeature(this.featureIndex);
        }

        public float getCriterionValueAsFloat() {
            return this.value;
        }

        public String getCriterionValueAsString() {
            return String.valueOf(this.value);
        }

        @Override
        public Node getNextNode(FeatureVector featureVector) {
            float val = this.isByteFeature ? (float)featureVector.getByteFeature(this.featureIndex) : featureVector.getContinuousFeature(this.featureIndex);
            Node returnNode = val < this.value ? this.daughters[0] : this.daughters[1];
            if (this.TRACE) {
                System.out.print(this.feature + ": " + val);
                if (val < this.value) {
                    System.out.print(" < ");
                } else {
                    System.out.print(" >= ");
                }
                System.out.println(this.value);
            }
            return returnNode;
        }

        @Override
        public String getDecisionPath(int daughterIndex) {
            String thisNodeInfo = daughterIndex == 0 ? this.feature + "<" + this.value : this.feature + ">=" + this.value;
            if (this.mother == null) {
                return thisNodeInfo;
            }
            if (this.mother.isDecisionNode()) {
                return ((DecisionNode)this.mother).getDecisionPath(this.getNodeIndex()) + " - " + thisNodeInfo;
            }
            return this.mother.getDecisionPath() + " - " + thisNodeInfo;
        }

        @Override
        public String getNodeDefinition() {
            return this.feature + " < " + this.value;
        }

        @Override
        public Type getDecisionNodeType() {
            return Type.BinaryFloatDecisionNode;
        }
    }

    public static class BinaryShortDecisionNode
    extends DecisionNode {
        private short value;

        public BinaryShortDecisionNode(String feature, String value, FeatureDefinition featureDefinition) {
            super(feature, 2, featureDefinition);
            this.value = featureDefinition.getFeatureValueAsShort(feature, value);
        }

        public BinaryShortDecisionNode(int featureIndex, short value, FeatureDefinition featureDefinition) {
            super(featureIndex, 2, featureDefinition);
            this.value = value;
        }

        public short getCriterionValueAsShort() {
            return this.value;
        }

        public String getCriterionValueAsString() {
            return this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value);
        }

        @Override
        public Node getNextNode(FeatureVector featureVector) {
            short val = featureVector.getShortFeature(this.featureIndex);
            Node returnNode = val == this.value ? this.daughters[0] : this.daughters[1];
            if (this.TRACE) {
                System.out.print(this.feature + ": " + this.featureDefinition.getFeatureValueAsString(this.featureIndex, val));
                if (val == this.value) {
                    System.out.print(" == ");
                } else {
                    System.out.print(" != ");
                }
                System.out.println(this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value));
            }
            return returnNode;
        }

        @Override
        public String getDecisionPath(int daughterIndex) {
            String thisNodeInfo = daughterIndex == 0 ? this.feature + "==" + this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value) : this.feature + "!=" + this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value);
            if (this.mother == null) {
                return thisNodeInfo;
            }
            if (this.mother.isDecisionNode()) {
                return ((DecisionNode)this.mother).getDecisionPath(this.getNodeIndex()) + " - " + thisNodeInfo;
            }
            return this.mother.getDecisionPath() + " - " + thisNodeInfo;
        }

        @Override
        public String getNodeDefinition() {
            return this.feature + " is " + this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value);
        }

        @Override
        public Type getDecisionNodeType() {
            return Type.BinaryShortDecisionNode;
        }
    }

    public static class BinaryByteDecisionNode
    extends DecisionNode {
        private byte value;

        public BinaryByteDecisionNode(String feature, String value, FeatureDefinition featureDefinition) {
            super(feature, 2, featureDefinition);
            this.value = featureDefinition.getFeatureValueAsByte(feature, value);
        }

        public BinaryByteDecisionNode(int featureIndex, byte value, FeatureDefinition featureDefinition) {
            super(featureIndex, 2, featureDefinition);
            this.value = value;
        }

        public BinaryByteDecisionNode(int uniqueId, FeatureDefinition featureDefinition) {
            super(2, featureDefinition);
            this.uniqueDecisionNodeId = uniqueId;
        }

        public void setFeatureAndFeatureValue(String feature, String value) {
            this.feature = feature;
            this.featureIndex = this.featureDefinition.getFeatureIndex(feature);
            this.value = this.featureDefinition.getFeatureValueAsByte(feature, value);
        }

        public byte getCriterionValueAsByte() {
            return this.value;
        }

        public String getCriterionValueAsString() {
            return this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value);
        }

        @Override
        public Node getNextNode(FeatureVector featureVector) {
            byte val = featureVector.getByteFeature(this.featureIndex);
            Node returnNode = val == this.value ? this.daughters[0] : this.daughters[1];
            if (this.TRACE) {
                System.out.print("    " + this.feature + ": " + this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value) + " == " + this.featureDefinition.getFeatureValueAsString(this.featureIndex, val));
                if (val == this.value) {
                    System.out.println(" YES ");
                } else {
                    System.out.println(" NO ");
                }
            }
            return returnNode;
        }

        @Override
        public String getDecisionPath(int daughterIndex) {
            String thisNodeInfo = daughterIndex == 0 ? this.feature + "==" + this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value) : this.feature + "!=" + this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value);
            if (this.mother == null) {
                return thisNodeInfo;
            }
            if (this.mother.isDecisionNode()) {
                return ((DecisionNode)this.mother).getDecisionPath(this.getNodeIndex()) + " - " + thisNodeInfo;
            }
            return this.mother.getDecisionPath() + " - " + thisNodeInfo;
        }

        @Override
        public String getNodeDefinition() {
            return this.feature + " is " + this.featureDefinition.getFeatureValueAsString(this.featureIndex, this.value);
        }

        @Override
        public Type getDecisionNodeType() {
            return Type.BinaryByteDecisionNode;
        }
    }

    public static enum Type {
        BinaryByteDecisionNode,
        BinaryShortDecisionNode,
        BinaryFloatDecisionNode,
        ByteDecisionNode,
        ShortDecisionNode;

    }
}

