/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.WelcomeNewAction;
import com.rapidminer.gui.actions.WelcomeOpenAction;
import com.rapidminer.gui.actions.WelcomeOpenRecentAction;
import com.rapidminer.gui.actions.WelcomeTutorialAction;
import com.rapidminer.gui.actions.WelcomeWizardAction;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ImagePanel;
import com.rapidminer.gui.tools.ImageTextPanel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.TextPanel;
import com.rapidminer.gui.tools.TipOfTheDayProvider;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class WelcomeScreen
extends JPanel {
    private static Image borderTopImage = null;
    private static Image borderBottomImage = null;
    private static Image bottomImage = null;
    private static Image newsImage = null;
    private static final long serialVersionUID = -6916236648023490473L;
    private JList recentFileList;
    private MainFrame mainFrame;

    static {
        try {
            URL url = Tools.getResource("welcome_border_top.png");
            if (url != null) {
                borderTopImage = ImageIO.read(url);
            }
            if ((url = Tools.getResource("welcome_border_bottom.png")) != null) {
                borderBottomImage = ImageIO.read(url);
            }
            if ((url = Tools.getResource("welcome_bottom.png")) != null) {
                bottomImage = ImageIO.read(url);
            }
        }
        catch (IOException e) {
            LogService.getGlobal().logWarning("Cannot load images for welcome screen. Using empty welcome screen...");
        }
    }

    public WelcomeScreen(MainFrame mainFrame, String newsText) {
        this.mainFrame = mainFrame;
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        JLabel welcomeLabel = new JLabel("Welcome to RapidMiner");
        welcomeLabel.setFont(new Font("SansSerif", 1, 20));
        welcomeLabel.setForeground(SwingTools.BROWN_FONT_COLOR);
        welcomeLabel.setBackground(Color.WHITE);
        welcomeLabel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        JPanel welcomeTextPanel = new JPanel(new FlowLayout(1));
        welcomeTextPanel.add(welcomeLabel);
        welcomeTextPanel.setBackground(Color.WHITE);
        layout.setConstraints(welcomeTextPanel, c);
        this.add(welcomeTextPanel);
        ImagePanel borderTopPanel = new ImagePanel(borderTopImage, 2);
        layout.setConstraints(borderTopPanel, c);
        this.add(borderTopPanel);
        ExtendedJToolBar actionBar = new ExtendedJToolBar();
        actionBar.setBorder(null);
        actionBar.setLayout(new FlowLayout(1));
        actionBar.setBackground(Color.WHITE);
        actionBar.setBorderPainted(false);
        JButton button = new JButton(new WelcomeNewAction(this.mainFrame));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        actionBar.add(button);
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        button = new JButton(new WelcomeOpenRecentAction(this.mainFrame, this));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        if (RapidMinerGUI.getRecentFiles().size() == 0) {
            button.setEnabled(false);
        }
        actionBar.add(button);
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        button = new JButton(new WelcomeOpenAction(this.mainFrame));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        actionBar.add(button);
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        button = new JButton(new WelcomeWizardAction(this.mainFrame));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        actionBar.add(button);
        actionBar.addSeparator();
        actionBar.addSeparator();
        button = new JButton(new WelcomeTutorialAction(this.mainFrame));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        actionBar.add(button);
        layout.setConstraints(actionBar, c);
        this.add(actionBar);
        this.recentFileList = new JList<Object>(RapidMinerGUI.getRecentFiles().toArray(new Object[RapidMinerGUI.getRecentFiles().size()]));
        this.recentFileList.setBorder(BorderFactory.createBevelBorder(1));
        this.recentFileList.setSelectionMode(0);
        this.recentFileList.setBorder(BorderFactory.createTitledBorder("Recent Files"));
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    WelcomeScreen.this.mainFrame.changeMode(0);
                    WelcomeScreen.this.openRecentProcess();
                }
            }
        };
        this.recentFileList.addMouseListener(mouseListener);
        JPanel listPanel = new JPanel(new FlowLayout(1));
        listPanel.add(this.recentFileList);
        listPanel.setBackground(Color.WHITE);
        layout.setConstraints(listPanel, c);
        this.add(listPanel);
        ImagePanel borderBottomPanel = new ImagePanel(borderBottomImage, 2);
        layout.setConstraints(borderBottomPanel, c);
        this.add(borderBottomPanel);
        ImagePanel bottomTextPanel = new ImagePanel(bottomImage, 0);
        BoxLayout textLayout = new BoxLayout(bottomTextPanel, 0);
        bottomTextPanel.setLayout(textLayout);
        final TipOfTheDayProvider tipProvider = new TipOfTheDayProvider();
        final TextPanel tipTextPanel = new TextPanel("Tip of the Day", this.nextTip(tipProvider), 0, 1);
        JLabel nextTipButton = new JLabel("Next Tip");
        nextTipButton.setFont(TextPanel.TEXT_FONT);
        nextTipButton.setForeground(SwingTools.LIGHT_BROWN_FONT_COLOR);
        nextTipButton.setAlignmentX(0.0f);
        nextTipButton.setAlignmentY(0.0f);
        nextTipButton.setOpaque(false);
        nextTipButton.setBorder(BorderFactory.createEmptyBorder(0, 24, 24, 0));
        nextTipButton.setCursor(new Cursor(12));
        nextTipButton.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                tipTextPanel.setText(WelcomeScreen.this.nextTip(tipProvider));
                WelcomeScreen.this.revalidate();
                WelcomeScreen.this.repaint();
            }
        });
        JPanel tipsPanel = new JPanel();
        tipsPanel.setOpaque(false);
        GridBagLayout tipLayout = new GridBagLayout();
        tipsPanel.setLayout(tipLayout);
        GridBagConstraints tipC = new GridBagConstraints();
        tipC.fill = 1;
        tipC.anchor = 18;
        tipC.gridwidth = 0;
        tipC.weightx = 1.0;
        JPanel fillPanel = new JPanel();
        fillPanel.setOpaque(false);
        tipC.weighty = 1.0;
        tipLayout.setConstraints(fillPanel, tipC);
        tipsPanel.add(fillPanel);
        tipC.weighty = 0.0;
        tipLayout.setConstraints(tipTextPanel, tipC);
        tipsPanel.add(tipTextPanel);
        tipLayout.setConstraints(nextTipButton, tipC);
        tipsPanel.add(nextTipButton);
        bottomTextPanel.add(tipsPanel);
        String transformedNewsText = Tools.transformAllLineSeparators(newsText);
        String[] newsLines = transformedNewsText.split("\n");
        TextPanel newsTextPanel = null;
        newsTextPanel = newsImage != null ? new ImageTextPanel(newsImage, "NEWS", newsLines, 1, 1, false, 0, -1) : new TextPanel("NEWS", newsLines, 1, 1);
        bottomTextPanel.add(newsTextPanel);
        c.weighty = 1.0;
        layout.setConstraints(bottomTextPanel, c);
        this.add(bottomTextPanel);
    }

    private String[] nextTip(TipOfTheDayProvider tipProvider) {
        String tipText = tipProvider.nextTip();
        String transformedTipText = tipText.replaceAll("<lb>", "\n");
        transformedTipText = transformedTipText.replaceAll("<indent>", "      ");
        transformedTipText = transformedTipText.replaceAll("<item>", "    * ");
        String[] tipLines = transformedTipText.split("\n");
        return tipLines;
    }

    public void openRecentProcess() {
        int selectedIndex = this.recentFileList.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (RapidMinerGUI.getRecentFiles().size() > 0) {
            this.mainFrame.open(RapidMinerGUI.getRecentFiles().get(selectedIndex));
        } else {
            this.mainFrame.open();
        }
    }
}

