/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.DimensionalityReducerModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DimensionalityReducer
extends Operator {
    public static final String PARAMETER_DIMENSIONS = "dimensions";

    public DimensionalityReducer(OperatorDescription description) {
        super(description);
    }

    protected abstract double[][] dimensionalityReduction(ExampleSet var1, int var2);

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet es = this.getInput(ExampleSet.class);
        int dimensions = this.getParameterAsInt(PARAMETER_DIMENSIONS);
        Tools.onlyNumericalAttributes(es, "dimensionality reduction");
        Tools.isNonEmpty(es);
        Tools.checkAndCreateIds(es);
        double[][] p = this.dimensionalityReduction(es, dimensions);
        DimensionalityReducerModel model = new DimensionalityReducerModel(es, p, dimensions);
        ExampleSet result = model.apply(es);
        if (this.getParameterAsBoolean("return_preprocessing_model")) {
            return new IOObject[]{result, model};
        }
        return new IOObject[]{result};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("return_preprocessing_model", "Indicates if the preprocessing model should also be returned", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_DIMENSIONS, "the number of dimensions in the result representation", 1, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

