/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.PCAModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.math.matrix.CovarianceMatrix;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCA
extends Operator {
    public static final String PARAMETER_VARIANCE_THRESHOLD = "variance_threshold";
    public static final String PARAMETER_NUMBER_OF_COMPONENTS = "number_of_components";
    public static final String PARAMETER_REDUCTION_TYPE = "dimensionality_reduction";
    public static final String[] REDUCTION_METHODS = new String[]{"none", "keep variance", "fixed number"};
    public static final int REDUCTION_NONE = 0;
    public static final int REDUCTION_VARIANCE = 1;
    public static final int REDUCTION_FIXED = 2;

    public PCA(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Tools.onlyNonMissingValues(exampleSet, "PCA");
        Tools.onlyNumericalAttributes(exampleSet, "PCA");
        this.log("Creating the covariance matrix...");
        Matrix covarianceMatrix = CovarianceMatrix.getCovarianceMatrix(exampleSet);
        this.log("Performing the eigenvalue decomposition...");
        EigenvalueDecomposition eigenvalueDecomposition = covarianceMatrix.eig();
        double[] eigenvalues = eigenvalueDecomposition.getRealEigenvalues();
        Matrix eigenvectorMatrix = eigenvalueDecomposition.getV();
        double[][] eigenvectors = eigenvectorMatrix.getArray();
        PCAModel model = new PCAModel(exampleSet, eigenvalues, eigenvectors);
        int reductionType = this.getParameterAsInt(PARAMETER_REDUCTION_TYPE);
        switch (reductionType) {
            case 0: {
                model.setNumberOfComponents(exampleSet.getAttributes().size());
                break;
            }
            case 1: {
                model.setVarianceThreshold(this.getParameterAsDouble(PARAMETER_VARIANCE_THRESHOLD));
                break;
            }
            case 2: {
                model.setNumberOfComponents(this.getParameterAsInt(PARAMETER_NUMBER_OF_COMPONENTS));
            }
        }
        return new IOObject[]{exampleSet, model};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDouble(PARAMETER_VARIANCE_THRESHOLD, "Keep the all components with a cumulative variance smaller than the given threshold.", 0.0, 1.0, 0.95);
        type.setExpert(false);
        list.add(type);
        type = new ParameterTypeCategory(PARAMETER_REDUCTION_TYPE, "Indicates which type of dimensionality reduction should be applied", REDUCTION_METHODS, 1);
        list.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_COMPONENTS, "Keep this number of components. If '-1' then keep all components.'", -1, Integer.MAX_VALUE, -1);
        list.add(type);
        return list;
    }
}

