/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import Jama.Matrix;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.meta.GridSearchParameterOptimizationOperator;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadraticParameterOptimizationOperator
extends GridSearchParameterOptimizationOperator {
    public static final String PARAMETER_IF_EXCEEDS_REGION = "if_exceeds_region";
    public static final String PARAMETER_IF_EXCEEDS_RANGE = "if_exceeds_range";
    private static final String[] EXCEED_BEHAVIORS = new String[]{"ignore", "clip", "fail"};
    private static final int IGNORE = 0;
    private static final int CLIP = 1;
    private static final int FAIL = 2;
    private ParameterSet best;

    public QuadraticParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public double getCurrentBestPerformance() {
        if (this.best != null) {
            return this.best.getPerformance().getMainCriterion().getAverage();
        }
        return Double.NaN;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IOObject[] apply() throws OperatorException {
        input = this.getInput();
        this.getParametersToOptimize();
        ifExceedsRegion = this.getParameterAsInt("if_exceeds_region");
        ifExceedsRange = this.getParameterAsInt("if_exceeds_range");
        index = 0;
        while (index < this.numberOfParameters) {
            valuesToSort = this.values[index];
            ind1 = 0;
            while (ind1 < valuesToSort.length) {
                val1 = Double.parseDouble(valuesToSort[ind1]);
                ind2 = ind1 + 1;
                while (ind2 < valuesToSort.length) {
                    val2 = Double.parseDouble(valuesToSort[ind2]);
                    if (val1 > val2) {
                        s = valuesToSort[ind1];
                        valuesToSort[ind1] = valuesToSort[ind2];
                        valuesToSort[ind2] = s;
                        val1 = val2;
                    }
                    ++ind2;
                }
                ++ind1;
            }
            ++index;
        }
        this.best = null;
        bestIndex = new int[this.numberOfParameters];
        allParameters = new ParameterSet[this.numberOfCombinations];
        paramIndex = 0;
        while (true) {
            this.log("Using parameter set");
            j = 0;
            while (j < this.operators.length) {
                this.operators[j].getParameters().setParameter(this.parameters[j], this.values[j][this.currentIndex[j]]);
                this.log(this.operators[j] + "." + this.parameters[j] + " = " + this.values[j][this.currentIndex[j]]);
                ++j;
            }
            this.setInput(input.copy());
            performance = this.getPerformance();
            currentValues = new String[this.parameters.length];
            j = 0;
            while (j < this.parameters.length) {
                currentValues[j] = this.values[j][this.currentIndex[j]];
                ++j;
            }
            allParameters[paramIndex] = new ParameterSet(this.operators, this.parameters, currentValues, performance);
            if (this.best == null || performance.compareTo(this.best.getPerformance()) > 0) {
                this.best = allParameters[paramIndex];
                j = 0;
                while (j < this.numberOfParameters) {
                    bestIndex[j] = this.currentIndex[j];
                    ++j;
                }
            }
            k = 0;
            ok = true;
            if (true) ** GOTO lbl62
            do {
                this.currentIndex[k] = 0;
                if (++k >= this.currentIndex.length) {
                    ok = false;
                    break;
                }
lbl62:
                // 3 sources

                v0 = k;
            } while ((this.currentIndex[v0] = this.currentIndex[v0] + 1) >= this.values[k].length);
            if (!ok) break;
            ++paramIndex;
        }
        nrParameters = 0;
        i = 0;
        while (i < this.numberOfParameters) {
            if (this.values[i].length > 2) {
                this.log("Param " + i + ", bestI = " + bestIndex[i]);
                ++nrParameters;
                if (bestIndex[i] == 0) {
                    v1 = i;
                    bestIndex[v1] = bestIndex[v1] + 1;
                }
                if (bestIndex[i] == this.values[i].length - 1) {
                    v2 = i;
                    bestIndex[v2] = bestIndex[v2] - 1;
                }
            } else {
                this.logWarning("Parameter " + this.parameters[i] + " has <3 values, skipped.");
            }
            ++i;
        }
        if (nrParameters > 3) {
            this.logWarning("Optimization not recommended for >3 values. Check results carefully!");
        }
        if (nrParameters > 0) {
            threetok = 1;
            i = 0;
            while (i < nrParameters) {
                threetok *= 3;
                ++i;
            }
            this.log("Optimising " + nrParameters + " parameters");
            Designmatrix = new Matrix(threetok, nrParameters + nrParameters * (nrParameters + 1) / 2 + 1);
            y = new Matrix(threetok, 1);
            paramIndex = 0;
            i = this.numberOfParameters - 1;
            while (i >= 0) {
                this.currentIndex[i] = this.values[i].length > 2 ? bestIndex[i] - 1 : bestIndex[i];
                paramIndex = paramIndex * this.values[i].length + this.currentIndex[i];
                --i;
            }
            row = 0;
            while (row < Designmatrix.getRowDimension()) {
                y.set(row, 0, allParameters[paramIndex].getPerformance().getMainCriterion().getFitness());
                Designmatrix.set(row, 0, 1.0);
                c = 1;
                i = 0;
                while (i < nrParameters) {
                    if (this.values[i].length > 2) {
                        Designmatrix.set(row, c, Double.parseDouble(this.values[i][this.currentIndex[i]]));
                        ++c;
                    }
                    ++i;
                }
                i = 0;
                while (i < nrParameters) {
                    if (this.values[i].length > 2) {
                        j = i + 1;
                        while (j < nrParameters) {
                            if (this.values[j].length > 2) {
                                Designmatrix.set(row, c, Double.parseDouble(this.values[i][this.currentIndex[i]]) * Double.parseDouble(this.values[j][this.currentIndex[j]]));
                                ++c;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < nrParameters) {
                    if (this.values[i].length > 2) {
                        Designmatrix.set(row, c, Double.parseDouble(this.values[i][this.currentIndex[i]]) * Double.parseDouble(this.values[i][this.currentIndex[i]]));
                        ++c;
                    }
                    ++i;
                }
                k = 0;
                c = 1;
                while (k < this.numberOfParameters) {
                    if (this.values[k].length > 2) {
                        v3 = k;
                        this.currentIndex[v3] = this.currentIndex[v3] + 1;
                        paramIndex += c;
                        if (this.currentIndex[k] <= bestIndex[k] + 1) break;
                        this.currentIndex[k] = bestIndex[k] - 1;
                        paramIndex -= 3 * c;
                        c *= this.values[k].length;
                        ++k;
                        continue;
                    }
                    c *= this.values[k].length;
                    ++k;
                }
                ++row;
            }
            beta = Designmatrix.solve(y);
            i = 0;
            while (i < Designmatrix.getColumnDimension()) {
                this.logWarning(" -- Writing " + beta.get(i, 0) + " at position " + i + " in vector b");
                ++i;
            }
            p = new Matrix(nrParameters, nrParameters);
            betapos = nrParameters + 1;
            j = 0;
            while (j < nrParameters - 1) {
                i = 1 + j;
                while (i < nrParameters) {
                    p.set(i, j, beta.get(betapos, 0) * 0.5);
                    p.set(j, i, beta.get(betapos, 0) * 0.5);
                    ++betapos;
                    ++i;
                }
                ++j;
            }
            i = 0;
            while (i < nrParameters) {
                p.set(i, i, beta.get(betapos, 0));
                ++betapos;
                ++i;
            }
            y2 = new Matrix(nrParameters, 1);
            i = 0;
            while (i < nrParameters) {
                y2.set(i, 0, beta.get(i + 1, 0));
                ++i;
            }
            y2 = y2.times(-0.5);
            x = new Matrix(nrParameters, 1);
            try {
                x = p.solve(y2);
            }
            catch (RuntimeException e) {
                this.logWarning("Quadratic optimization failed. (invalid matrix)");
            }
            Qvalues = new String[this.numberOfParameters];
            pc = 0;
            ok = true;
            j = 0;
            while (j < this.numberOfParameters) {
                if (this.values[j].length > 2) {
                    if (x.get(pc, 0) > Double.parseDouble(this.values[j][bestIndex[j] + 1]) || x.get(pc, 0) < Double.parseDouble(this.values[j][bestIndex[j] - 1])) {
                        this.logWarning("Parameter " + this.parameters[j] + " exceeds region of interest (" + x.get(pc, 0) + ")");
                        if (ifExceedsRegion == 1) {
                            if (x.get(pc, 0) > Double.parseDouble(this.values[j][bestIndex[j] + 1])) {
                                x.set(pc, 0, Double.parseDouble(this.values[j][bestIndex[j] + 1]));
                            } else {
                                x.set(pc, 0, Double.parseDouble(this.values[j][bestIndex[j] - 1]));
                            }
                        } else if (ifExceedsRegion == 2) {
                            ok = false;
                        }
                    }
                    if (x.get(pc, 0) < Double.parseDouble(this.values[j][0]) || x.get(pc, 0) > Double.parseDouble(this.values[j][this.values[j].length - 1])) {
                        this.logWarning("Parameter " + this.parameters[j] + " exceeds range (" + x.get(pc, 0) + ")");
                        if (ifExceedsRange == 0) {
                            this.logWarning("  but no measures taken. Check parameters manually!");
                        } else if (ifExceedsRange == 1) {
                            if (x.get(pc, 0) > Double.parseDouble(this.values[j][0])) {
                                x.set(pc, 0, Double.parseDouble(this.values[j][0]));
                            } else {
                                x.set(pc, 0, Double.parseDouble(this.values[j][this.values[j].length - 1]));
                            }
                        } else {
                            ok = false;
                        }
                    }
                    Qvalues[j] = String.valueOf(x.get(pc, 0));
                    ++pc;
                } else {
                    Qvalues[j] = this.values[j][bestIndex[j]];
                }
                ++j;
            }
            this.logWarning("Optimised parameter set:");
            j = 0;
            while (j < this.operators.length) {
                this.operators[j].getParameters().setParameter(this.parameters[j], Qvalues[j]);
                this.log("  " + this.operators[j] + "." + this.parameters[j] + " = " + Qvalues[j]);
                ++j;
            }
            if (ok) {
                this.setInput(input.copy());
                Qperformance = this.getPerformance();
                this.log("Old: " + this.best.getPerformance().getMainCriterion().getFitness());
                this.log("New: " + Qperformance.getMainCriterion().getFitness());
                if (Qperformance.compareTo(this.best.getPerformance()) > 0) {
                    this.best = new ParameterSet(this.operators, this.parameters, Qvalues, Qperformance);
                    this.log("Optimised parameter set does increase the performance");
                } else {
                    this.log("Could not increase performance by quadratic optimization");
                }
            } else {
                this.logWarning("Parameters outside admissible range, not using optimised parameter set.");
            }
        } else {
            this.logWarning("No parameters to optimize");
        }
        return new IOObject[]{this.best, this.best.getPerformance()};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_IF_EXCEEDS_REGION, "What to do if range is exceeded.", EXCEED_BEHAVIORS, 1));
        types.add(new ParameterTypeCategory(PARAMETER_IF_EXCEEDS_RANGE, "What to do if range is exceeded.", EXCEED_BEHAVIORS, 2));
        return types;
    }
}

