/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDuplicates
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";

    public RemoveDuplicates(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int[] partition = new int[exampleSet.size()];
        Pattern pattern = Pattern.compile(this.getParameterAsString(PARAMETER_ATTRIBUTES));
        LinkedList<Attribute> compareAttributes = new LinkedList<Attribute>();
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        while (a.hasNext()) {
            Attribute candidate = a.next();
            Matcher matcher = pattern.matcher(candidate.getName());
            if (!matcher.matches()) continue;
            compareAttributes.add(candidate);
        }
        int i = 0;
        while (i < exampleSet.size()) {
            Example example = exampleSet.getExample(i);
            int j = i + 1;
            while (j < exampleSet.size()) {
                Example compExample = exampleSet.getExample(j);
                if (partition[j] == 0) {
                    boolean equal = true;
                    for (Attribute attribute : compareAttributes) {
                        if (attribute.isNominal()) {
                            String secondValue;
                            String firstValue = example.getNominalValue(attribute);
                            if (firstValue.equals(secondValue = compExample.getNominalValue(attribute))) continue;
                            equal = false;
                            break;
                        }
                        if (example.getValue(attribute) == compExample.getValue(attribute)) continue;
                        equal = false;
                        break;
                    }
                    if (equal) {
                        partition[j] = 1;
                    }
                }
                ++j;
            }
            ++i;
        }
        SplittedExampleSet result = new SplittedExampleSet(exampleSet, new Partition(partition, 2));
        result.selectSingleSubset(0);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTES, "The attributes which should be used for the check (regular expression, use .* for all attributes).", ".*"));
        return types;
    }
}

