/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.test;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationReal;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.OpdfGaussianMixture;
import be.ac.ulg.montefiore.run.jahmm.OpdfMultiGaussian;
import junit.framework.TestCase;

public class GaussianTest
extends TestCase {
    private static final double DELTA = 0.05;
    private static final int nbObservations = 10000;

    public void testGaussianFit() {
        double[] mean = new double[]{2.0, 4.0};
        double[][] covariance = new double[][]{{3.0, 2.0}, {2.0, 4.0}};
        OpdfMultiGaussian omg1 = new OpdfMultiGaussian(mean, covariance);
        GaussianTest.assertEquals((int)omg1.dimension(), (int)2);
        ObservationVector[] obs = new ObservationVector[10000];
        int i = 0;
        while (i < obs.length) {
            obs[i] = omg1.generate();
            ++i;
        }
        OpdfMultiGaussian omg2 = new OpdfMultiGaussian(new double[]{0.0, 0.0}, new double[][]{{0.0, 0.0}, {0.0, 0.0}});
        GaussianTest.assertEquals((int)omg2.dimension(), (int)2);
        omg2.fit(obs);
        GaussianTest.assertTrue((String)("Different mean arrays: " + GaussianTest.toString(mean) + " differ from " + GaussianTest.toString(omg2.mean())), (boolean)GaussianTest.equalsArrays(mean, omg2.mean()));
        int i2 = 0;
        while (i2 < 2) {
            GaussianTest.assertTrue((String)("Different covariance arrays: " + GaussianTest.toString(omg1.covariance()[i2]) + " differ from " + GaussianTest.toString(omg2.covariance()[i2])), (boolean)GaussianTest.equalsArrays(omg1.covariance()[i2], omg2.covariance()[i2], 0.5));
            ++i2;
        }
    }

    public void testGaussianMixture() {
        ObservationReal[] observations = new ObservationReal[10000];
        int g = 0;
        int i = 0;
        while (g < 2) {
            GaussianDistribution d = new GaussianDistribution((double)g * 4.0, 1 + g);
            while (i < (g == 0 ? 3333 : 10000)) {
                observations[i] = new ObservationReal(d.generate());
                ++i;
            }
            ++g;
        }
        OpdfGaussianMixture gm = new OpdfGaussianMixture(2);
        i = 0;
        while (i < 20) {
            gm.fit(observations);
            ++i;
        }
        GaussianTest.assertTrue((String)("Wrong proportion values (" + gm.proportions()[0] + ", " + gm.proportions()[1] + ")"), (boolean)GaussianTest.equalsArrays(new double[]{0.3333333333333333, 0.6666666666666666}, gm.proportions(), 0.05));
        GaussianTest.assertTrue((String)("Wrong mean values (" + gm.means()[0] + ", " + gm.means()[1] + ")"), (boolean)GaussianTest.equalsArrays(new double[]{0.0, 4.0}, gm.means(), 0.5));
        GaussianTest.assertTrue((String)("Wrong variance values (" + gm.variances()[0] + ", " + gm.variances()[1] + ")"), (boolean)GaussianTest.equalsArrays(new double[]{1.0, 2.0}, gm.variances(), 0.5));
    }

    public void testMultiGaussianFit() {
        double[] mean = new double[]{2.0, 4.0};
        double[][] covariance = new double[][]{{3.0, 2.0}, {2.0, 4.0}};
        OpdfMultiGaussian omg1 = new OpdfMultiGaussian(mean, covariance);
        GaussianTest.assertEquals((int)omg1.dimension(), (int)2);
        ObservationVector[] obs = new ObservationVector[100000];
        int i = 0;
        while (i < obs.length) {
            obs[i] = omg1.generate();
            ++i;
        }
        OpdfMultiGaussian omg2 = new OpdfMultiGaussian(new double[]{0.0, 0.0}, new double[][]{{0.0, 0.0}, {0.0, 0.0}});
        GaussianTest.assertEquals((int)omg2.dimension(), (int)2);
        omg2.fit(obs);
        GaussianTest.assertTrue((String)"Different mean arrays", (boolean)GaussianTest.equalsArrays(mean, omg2.mean()));
        int i2 = 0;
        while (i2 < 2) {
            GaussianTest.assertTrue((String)"Different covariance arrays", (boolean)GaussianTest.equalsArrays(omg1.covariance()[i2], omg2.covariance()[i2]));
            ++i2;
        }
    }

    static String toString(double[] a) {
        String s = "[ ";
        double[] dArray = a;
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            double e = dArray[n];
            s = String.valueOf(s) + e + " ";
            ++n;
        }
        return String.valueOf(s) + "]";
    }

    static boolean equalsArrays(double[] ea, double[] ra) {
        return GaussianTest.equalsArrays(ea, ra, 0.05);
    }

    static boolean equalsArrays(double[] ea, double[] ra, double delta) {
        if (ea.length != ra.length) {
            return false;
        }
        int i = 0;
        while (i < ra.length) {
            if (Math.abs(ea[i] - ra[i]) > delta) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

