/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViterbiCalculator {
    private double[][] delta;
    private int[][] psy;
    private int[] stateSequence;
    private double lnProbability;

    public <O extends Observation> ViterbiCalculator(List<? extends O> oseq, Hmm<O> hmm) {
        if (oseq.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty sequence");
        }
        this.delta = new double[oseq.size()][hmm.nbStates()];
        this.psy = new int[oseq.size()][hmm.nbStates()];
        this.stateSequence = new int[oseq.size()];
        int i = 0;
        while (i < hmm.nbStates()) {
            this.delta[0][i] = -Math.log(hmm.getPi(i)) - Math.log(hmm.getOpdf(i).probability((Observation)oseq.get(0)));
            this.psy[0][i] = 0;
            ++i;
        }
        Iterator<O> oseqIterator = oseq.iterator();
        if (oseqIterator.hasNext()) {
            oseqIterator.next();
        }
        int t = 1;
        while (oseqIterator.hasNext()) {
            Observation observation = (Observation)oseqIterator.next();
            int i2 = 0;
            while (i2 < hmm.nbStates()) {
                this.computeStep(hmm, observation, t, i2);
                ++i2;
            }
            ++t;
        }
        this.lnProbability = Double.MAX_VALUE;
        int i3 = 0;
        while (i3 < hmm.nbStates()) {
            double thisProbability = this.delta[oseq.size() - 1][i3];
            if (this.lnProbability > thisProbability) {
                this.lnProbability = thisProbability;
                this.stateSequence[oseq.size() - 1] = i3;
            }
            ++i3;
        }
        this.lnProbability = -this.lnProbability;
        int t2 = oseq.size() - 2;
        while (t2 >= 0) {
            this.stateSequence[t2] = this.psy[t2 + 1][this.stateSequence[t2 + 1]];
            --t2;
        }
    }

    private <O extends Observation> void computeStep(Hmm<O> hmm, O o, int t, int j) {
        double minDelta = Double.MAX_VALUE;
        int min_psy = 0;
        int i = 0;
        while (i < hmm.nbStates()) {
            double thisDelta = this.delta[t - 1][i] - Math.log(hmm.getAij(i, j));
            if (minDelta > thisDelta) {
                minDelta = thisDelta;
                min_psy = i;
            }
            ++i;
        }
        this.delta[t][j] = minDelta - Math.log(hmm.getOpdf(j).probability(o));
        this.psy[t][j] = min_psy;
    }

    public double lnProbability() {
        return this.lnProbability;
    }

    public int[] stateSequence() {
        return (int[])this.stateSequence.clone();
    }
}

