/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class ExtendedJTableColumnFitMouseListener
extends MouseAdapter {
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTableHeader header = (JTableHeader)e.getSource();
            TableColumn tableColumn = this.getResizingColumn(header, e.getPoint());
            if (tableColumn == null) {
                return;
            }
            JTable table = header.getTable();
            if ((e.getModifiers() & 2) == 2) {
                if (table instanceof ExtendedJTable) {
                    ((ExtendedJTable)table).pack();
                    e.consume();
                }
            } else {
                ExtendedJScrollPane scrollPane;
                int col = header.getColumnModel().getColumnIndex(tableColumn.getIdentifier());
                int width = (int)header.getDefaultRenderer().getTableCellRendererComponent(table, tableColumn.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
                int firstRow = 0;
                int lastRow = table.getRowCount();
                if (table instanceof ExtendedJTable && (scrollPane = ((ExtendedJTable)table).getExtendedScrollPane()) != null) {
                    JViewport viewport = scrollPane.getViewport();
                    Rectangle viewRect = viewport.getViewRect();
                    if (viewport.getHeight() < table.getHeight()) {
                        firstRow = table.rowAtPoint(new Point(0, viewRect.y));
                        firstRow = Math.max(0, firstRow);
                        lastRow = table.rowAtPoint(new Point(0, viewRect.y + viewRect.height - 1));
                        lastRow = Math.min(lastRow, table.getRowCount());
                    }
                }
                int row = firstRow;
                while (row < lastRow) {
                    int preferedWidth = (int)table.getCellRenderer(row, col).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                    width = Math.max(width, preferedWidth);
                    ++row;
                }
                header.setResizingColumn(tableColumn);
                tableColumn.setWidth(width + table.getIntercellSpacing().width);
                e.consume();
            }
        }
    }

    private TableColumn getResizingColumn(JTableHeader header, Point p) {
        return this.getResizingColumn(header, p, header.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(JTableHeader header, Point p, int column) {
        if (column == -1) {
            return null;
        }
        Rectangle r = header.getHeaderRect(column);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        int columnIndex = 0;
        if (header.getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return header.getColumnModel().getColumn(columnIndex);
    }
}

