/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOObjectReader
extends Operator {
    public static final String PARAMETER_OBJECT_FILE = "object_file";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_IGNORE_TYPE = "ignore_type";
    private String[] objectArray = null;

    public IOObjectReader(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        return new IOObject[]{this.read()};
    }

    protected IOObject read() throws OperatorException {
        IOObject object;
        block31: {
            object = null;
            ObjectInputStream objectIn = null;
            try {
                try {
                    objectIn = new ObjectInputStream(this.getParameterAsInputStream(PARAMETER_OBJECT_FILE));
                    object = (IOObject)objectIn.readObject();
                    objectIn.close();
                }
                catch (Exception e) {
                    this.log("Cannot deserialize binary object, trying XML deserialization...");
                    InputStream in = null;
                    try {
                        in = new GZIPInputStream(this.getParameterAsInputStream(PARAMETER_OBJECT_FILE));
                    }
                    catch (IOException e1) {
                        try {
                            in = this.getParameterAsInputStream(PARAMETER_OBJECT_FILE);
                        }
                        catch (IOException e2) {
                            throw new UserError((Operator)this, (Throwable)e, 302, this.getParameter(PARAMETER_OBJECT_FILE), e2.getMessage());
                        }
                    }
                    try {
                        try {
                            object = AbstractIOObject.read(in);
                        }
                        catch (IOException e3) {
                            throw new UserError((Operator)this, (Throwable)e, 302, this.getParameter(PARAMETER_OBJECT_FILE), e3.getMessage());
                        }
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e1) {
                                this.logError("Cannot close stream to file " + this.getParameter(PARAMETER_OBJECT_FILE));
                            }
                        }
                    }
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (objectIn != null) {
                    try {
                        objectIn.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (objectIn != null) {
                try {
                    objectIn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (object == null) {
            throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_OBJECT_FILE), "cannot load object file");
        }
        Class<IOObject> clazz = this.getSelectedClass();
        if (!clazz.isInstance(object) && !this.getParameterAsBoolean(PARAMETER_IGNORE_TYPE)) {
            throw new UserError((Operator)this, 942, this.getParameter(PARAMETER_OBJECT_FILE), Tools.classNameWOPackage(clazz), Tools.classNameWOPackage(object.getClass()));
        }
        return object;
    }

    private Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.getIOObjectNames() != null) {
            return OperatorService.getIOObjectClass(this.getIOObjectNames()[ioType]);
        }
        return null;
    }

    private String[] getIOObjectNames() {
        if (this.objectArray == null) {
            Set<String> ioObjects = OperatorService.getIOObjectsNames();
            this.objectArray = ioObjects.toArray(new String[ioObjects.size()]);
        }
        return this.objectArray;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_OBJECT_FILE, "Filename of the object file.", "ioo", false));
        types.add(new ParameterTypeBoolean(PARAMETER_IGNORE_TYPE, "Indicates if the execution should be aborted if type of read object does not match selected type.", false));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be saved.", this.getIOObjectNames(), 0);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_IGNORE_TYPE, false, false));
        types.add(type);
        return types;
    }
}

