/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.sampling;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.sampling.AbstractStratifiedSampling;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteStratifiedSampling
extends AbstractStratifiedSampling {
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";

    public AbsoluteStratifiedSampling(OperatorDescription description) {
        super(description);
    }

    @Override
    public double getRatio(ExampleSet exampleSet) throws OperatorException {
        double targetSize = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
        if (targetSize > (double)exampleSet.size()) {
            return 1.0;
        }
        return targetSize / (double)exampleSet.size();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The number of examples which should be sampled", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

