/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelWriter;
import opennlp.perceptron.BinaryPerceptronModelWriter;
import opennlp.perceptron.PerceptronModelWriter;
import opennlp.perceptron.PlainTextPerceptronModelWriter;

public class SuffixSensitivePerceptronModelWriter
extends PerceptronModelWriter {
    private final AbstractModelWriter suffixAppropriateWriter;

    public SuffixSensitivePerceptronModelWriter(AbstractModel model, File f) throws IOException {
        super(model);
        FilterOutputStream output;
        String filename = f.getName();
        if (filename.endsWith(".gz")) {
            output = new GZIPOutputStream(new FileOutputStream(f));
            filename = filename.substring(0, filename.length() - 3);
        } else {
            output = new DataOutputStream(new FileOutputStream(f));
        }
        this.suffixAppropriateWriter = filename.endsWith(".bin") ? new BinaryPerceptronModelWriter(model, new DataOutputStream(output)) : new PlainTextPerceptronModelWriter(model, new BufferedWriter(new OutputStreamWriter(output)));
    }

    public void writeUTF(String s) throws IOException {
        this.suffixAppropriateWriter.writeUTF(s);
    }

    public void writeInt(int i) throws IOException {
        this.suffixAppropriateWriter.writeInt(i);
    }

    public void writeDouble(double d) throws IOException {
        this.suffixAppropriateWriter.writeDouble(d);
    }

    public void close() throws IOException {
        this.suffixAppropriateWriter.close();
    }
}

