/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.taxamatch.fin.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.dataanalysis.taxamatch.fin.client.GreetingService;
import org.gcube.dataanalysis.taxamatch.fin.client.GreetingServiceAsync;
import org.gcube.dataanalysis.taxamatch.fin.shared.FieldVerifier;

public class TaxamatchPostgres
implements EntryPoint {
    private static final String SERVER_ERROR = "An error occurred while attempting to contact the server. Please check your network connection and try again.";
    private final GreetingServiceAsync greetingService = (GreetingServiceAsync)GWT.create(GreetingService.class);

    public void onModuleLoad() {
        final Button sendButton = new Button("Send");
        TextBox nameField = new TextBox();
        nameField.setText("GWT User");
        Label errorLabel = new Label();
        sendButton.addStyleName("sendButton");
        RootPanel.get((String)"nameFieldContainer").add((Widget)nameField);
        RootPanel.get((String)"sendButtonContainer").add((Widget)sendButton);
        RootPanel.get((String)"errorLabelContainer").add((Widget)errorLabel);
        nameField.setFocus(true);
        nameField.selectAll();
        final DialogBox dialogBox = new DialogBox();
        dialogBox.setText("Remote Procedure Call");
        dialogBox.setAnimationEnabled(true);
        Button closeButton = new Button("Close");
        closeButton.getElement().setId("closeButton");
        Label textToServerLabel = new Label();
        HTML serverResponseLabel = new HTML();
        VerticalPanel dialogVPanel = new VerticalPanel();
        dialogVPanel.addStyleName("dialogVPanel");
        dialogVPanel.add((Widget)new HTML("<b>Sending name to the server:</b>"));
        dialogVPanel.add((Widget)textToServerLabel);
        dialogVPanel.add((Widget)new HTML("<br><b>Server replies:</b>"));
        dialogVPanel.add((Widget)serverResponseLabel);
        dialogVPanel.setHorizontalAlignment(VerticalPanel.ALIGN_RIGHT);
        dialogVPanel.add((Widget)closeButton);
        dialogBox.setWidget((Widget)dialogVPanel);
        closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                sendButton.setEnabled(true);
                sendButton.setFocus(true);
            }
        });
        class MyHandler
        implements ClickHandler,
        KeyUpHandler {
            private final /* synthetic */ Label val$errorLabel;
            private final /* synthetic */ TextBox val$nameField;
            private final /* synthetic */ Button val$sendButton;
            private final /* synthetic */ Label val$textToServerLabel;
            private final /* synthetic */ HTML val$serverResponseLabel;
            private final /* synthetic */ DialogBox val$dialogBox;
            private final /* synthetic */ Button val$closeButton;

            MyHandler(Label label, TextBox textBox, Button button, Label label2, HTML hTML, DialogBox dialogBox, Button button2) {
                this.val$errorLabel = label;
                this.val$nameField = textBox;
                this.val$sendButton = button;
                this.val$textToServerLabel = label2;
                this.val$serverResponseLabel = hTML;
                this.val$dialogBox = dialogBox;
                this.val$closeButton = button2;
            }

            public void onClick(ClickEvent event) {
                this.sendNameToServer();
            }

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    this.sendNameToServer();
                }
            }

            private void sendNameToServer() {
                this.val$errorLabel.setText("");
                String textToServer = this.val$nameField.getText();
                if (!FieldVerifier.isValidName(textToServer)) {
                    this.val$errorLabel.setText("Please enter at least four characters");
                    return;
                }
                this.val$sendButton.setEnabled(false);
                this.val$textToServerLabel.setText(textToServer);
                this.val$serverResponseLabel.setText("");
                TaxamatchPostgres.this.greetingService.greetServer(textToServer, new AsyncCallback<String>(){

                    public void onFailure(Throwable caught) {
                        val$dialogBox.setText("Remote Procedure Call - Failure");
                        val$serverResponseLabel.addStyleName("serverResponseLabelError");
                        val$serverResponseLabel.setHTML(TaxamatchPostgres.SERVER_ERROR);
                        val$dialogBox.center();
                        val$closeButton.setFocus(true);
                    }

                    public void onSuccess(String result) {
                        val$dialogBox.setText("Remote Procedure Call");
                        val$serverResponseLabel.removeStyleName("serverResponseLabelError");
                        val$serverResponseLabel.setHTML(result);
                        val$dialogBox.center();
                        val$closeButton.setFocus(true);
                    }
                });
            }
        }
        MyHandler handler = new MyHandler(errorLabel, nameField, sendButton, textToServerLabel, serverResponseLabel, dialogBox, closeButton);
        sendButton.addClickHandler((ClickHandler)handler);
        nameField.addKeyUpHandler((KeyUpHandler)handler);
    }
}

