/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.synthesis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.synthesis.MBROLAPhoneme;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.server.MaryProperties;

public class MbrolaVoice
extends Voice {
    private String path;
    private Set<String> missingDiphones;
    private List<String> knownVoiceQualities;
    private int topStart;
    private int topEnd;
    private int baseStart;
    private int baseEnd;
    private Map<String, String> sampa2voiceMap;
    private Map<String, String> voice2sampaMap;

    public MbrolaVoice(String path, String[] nameArray, Locale locale, AudioFormat dbAudioFormat, WaveformSynthesizer synthesizer, Voice.Gender gender, int topStart, int topEnd, int baseStart, int baseEnd, String[] knownVoiceQualities, String missingDiphonesPath) throws MaryConfigurationException {
        super(nameArray[0], locale, dbAudioFormat, synthesizer, gender);
        this.topStart = topStart;
        this.topEnd = topEnd;
        this.baseStart = baseStart;
        this.baseEnd = baseEnd;
        this.fillSampaMap();
        this.path = path;
        this.knownVoiceQualities = new ArrayList<String>();
        if (knownVoiceQualities != null) {
            for (int j = 0; j < knownVoiceQualities.length; ++j) {
                this.knownVoiceQualities.add(knownVoiceQualities[j]);
            }
        }
        if (missingDiphonesPath != null) {
            File missingDiphonesFile = new File(missingDiphonesPath);
            try {
                BufferedReader br = new BufferedReader(new FileReader(missingDiphonesFile));
                String diphone = null;
                this.missingDiphones = new HashSet<String>();
                while ((diphone = br.readLine()) != null) {
                    this.missingDiphones.add(diphone);
                }
            }
            catch (IOException e) {
                this.missingDiphones = null;
            }
        }
    }

    public String path() {
        return this.path;
    }

    public int topStart() {
        return this.topStart;
    }

    public int topEnd() {
        return this.topEnd;
    }

    public int baseStart() {
        return this.baseStart;
    }

    public int baseEnd() {
        return this.baseEnd;
    }

    public boolean hasVoiceQuality(String vq) {
        return this.knownVoiceQualities.contains(vq);
    }

    private void fillSampaMap() {
        String sampamap;
        String sampamapFilename = MaryProperties.getFilename("voice." + this.getName() + ".sampamapfile");
        if (sampamapFilename != null) {
            logger.debug("For voice " + this.getName() + ", filling sampa map from file " + sampamapFilename);
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sampamapFilename), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                    try {
                        this.addSampaMapEntry(line);
                    }
                    catch (IllegalArgumentException iae) {
                        logger.warn("Ignoring invalid entry in sampa map file " + sampamapFilename);
                    }
                }
            }
            catch (IOException ioe) {
                logger.warn("Cannot open file '" + sampamapFilename + "' referenced in mary config file field voice." + this.getName() + ".sampamapfile");
            }
        }
        if ((sampamap = MaryProperties.getProperty("voice." + this.getName() + ".sampamap")) != null) {
            logger.debug("For voice " + this.getName() + ", filling sampa map from config file");
            StringTokenizer sst = new StringTokenizer(sampamap);
            while (sst.hasMoreTokens()) {
                try {
                    this.addSampaMapEntry(sst.nextToken());
                }
                catch (IllegalArgumentException iae) {
                    logger.warn("Ignoring invalid entry in mary config file, field voice." + this.getName() + ".sampamap");
                }
            }
        }
    }

    private void addSampaMapEntry(String entry) throws IllegalArgumentException {
        boolean s2v = false;
        boolean v2s = false;
        String[] parts = null;
        if ((entry = entry.replace('+', ' ')).indexOf("<->") != -1) {
            parts = entry.split("<->");
            s2v = true;
            v2s = true;
        } else if (entry.indexOf("->") != -1) {
            parts = entry.split("->");
            s2v = true;
        } else if (entry.indexOf("<-") != -1) {
            parts = entry.split("<-");
            v2s = true;
        }
        if (parts == null || parts.length != 2) {
            throw new IllegalArgumentException();
        }
        if (s2v) {
            if (this.sampa2voiceMap == null) {
                this.sampa2voiceMap = new HashMap<String, String>();
            }
            this.sampa2voiceMap.put(parts[0].trim(), parts[1].trim());
        }
        if (v2s) {
            if (this.voice2sampaMap == null) {
                this.voice2sampaMap = new HashMap<String, String>();
            }
            this.voice2sampaMap.put(parts[1].trim(), parts[0].trim());
        }
    }

    public String voice2sampa(String voicePhoneme) {
        if (this.voice2sampaMap != null && this.voice2sampaMap.containsKey(voicePhoneme)) {
            return this.voice2sampaMap.get(voicePhoneme);
        }
        return voicePhoneme;
    }

    public String sampa2voice(String sampaPhoneme) {
        if (this.sampa2voiceMap != null && this.sampa2voiceMap.containsKey(sampaPhoneme)) {
            return this.sampa2voiceMap.get(sampaPhoneme);
        }
        return sampaPhoneme;
    }

    public Vector<MBROLAPhoneme> convertSampa(MBROLAPhoneme maryPhoneme) {
        Vector<MBROLAPhoneme> phones = new Vector<MBROLAPhoneme>();
        String marySampa = maryPhoneme.getSymbol();
        if (this.sampa2voiceMap != null && this.sampa2voiceMap.containsKey(marySampa)) {
            String newSampa = this.sampa2voiceMap.get(marySampa);
            Vector<String> newSampas = new Vector<String>();
            StringTokenizer st = new StringTokenizer(newSampa);
            while (st.hasMoreTokens()) {
                newSampas.add(st.nextToken());
            }
            int n = newSampas.size();
            int totalDur = maryPhoneme.getDuration();
            Vector<int[]> allTargets = maryPhoneme.getTargets();
            for (int i = 0; i < newSampas.size(); ++i) {
                String sampa = (String)newSampas.get(i);
                int dur = totalDur / n;
                Vector<int[]> newTargets = null;
                int maxP = 100 * (i + 1) / n;
                boolean ok = true;
                while (allTargets != null && allTargets.size() > 0 && ok) {
                    int[] oldTarget = allTargets.get(0);
                    if (oldTarget[0] <= maxP) {
                        int[] newTarget = new int[]{oldTarget[0] * n, oldTarget[1]};
                        if (newTargets == null) {
                            newTargets = new Vector<int[]>();
                        }
                        newTargets.add(newTarget);
                        allTargets.remove(0);
                        continue;
                    }
                    ok = false;
                }
                MBROLAPhoneme mp = new MBROLAPhoneme(sampa, dur, newTargets, maryPhoneme.getVoiceQuality());
                phones.add(mp);
            }
        } else {
            phones.add(maryPhoneme);
        }
        return phones;
    }

    public boolean hasDiphone(MBROLAPhoneme p1, MBROLAPhoneme p2) {
        return this.hasDiphone(p1.getSymbol() + "-" + p2.getSymbol());
    }

    public boolean hasDiphone(String diphone) {
        return this.missingDiphones == null || !this.missingDiphones.contains(diphone);
    }

    public Vector<MBROLAPhoneme> replaceDiphone(MBROLAPhoneme p1, MBROLAPhoneme p2) {
        Vector<MBROLAPhoneme> phones = new Vector<MBROLAPhoneme>();
        String s1 = p1.getSymbol();
        String s2 = p2.getSymbol();
        boolean solved = false;
        if (this.hasDiphone(s1 + "-_") && this.hasDiphone("_-" + s2)) {
            phones.add(p1);
            phones.add(new MBROLAPhoneme("_", 10, null, null));
            phones.add(p2);
            solved = true;
        }
        if (!solved) {
            String s1a = null;
            String s2a = s2;
            if (s1.equals("E~") || s1.equals("e~")) {
                s1a = "E";
            } else if (s1.equals("9^") || s1.equals("9~")) {
                s1a = "9";
            } else if (s1.equals("a~")) {
                s1a = "O";
            } else if (s1.equals("o~")) {
                s1a = "o:";
            }
            if (s1a != null) {
                if (this.hasDiphone(s1a + "-" + s2)) {
                    p1.setSymbol(s1a);
                    phones.add(p1);
                    phones.add(p2);
                    solved = true;
                } else if (this.hasDiphone(s1a + "-N") && this.hasDiphone("N-" + s2)) {
                    p1.setSymbol(s1a);
                    p1.setDuration(p1.getDuration() - 30);
                    phones.add(p1);
                    phones.add(new MBROLAPhoneme("N", 30, null, null));
                    phones.add(p2);
                    solved = true;
                }
            } else {
                if (s2.equals("E~") || s2.equals("e~")) {
                    s2a = "E:";
                } else if (s2.equals("9^") || s2.equals("9~")) {
                    s2a = "9";
                } else if (s2.equals("a~")) {
                    s2a = "O";
                } else if (s2.equals("o~")) {
                    s2a = "o:";
                }
                if (s2a != null && this.hasDiphone(s1 + "-" + s2a)) {
                    p2.setSymbol(s2a);
                    phones.add(p1);
                    phones.add(p2);
                    solved = true;
                } else if (s1a != null && s2a != null && this.hasDiphone(s1a + "-" + s2a)) {
                    p1.setSymbol(s1a);
                    p2.setSymbol(s2a);
                    phones.add(p1);
                    phones.add(p2);
                    solved = true;
                }
            }
        }
        if (!solved && s1.equals("a:") && this.hasDiphone("a-" + s2)) {
            p1.setSymbol("a");
            phones.add(p1);
            phones.add(p2);
            solved = true;
        }
        if (!solved && s2.equals("a:") && this.hasDiphone(s1 + "-a")) {
            p2.setSymbol("a");
            phones.add(p1);
            phones.add(p2);
            solved = true;
        }
        if (!solved && s1.equals("j") && this.hasDiphone("i:-" + s2)) {
            p1.setSymbol("i:");
            phones.add(p1);
            phones.add(p2);
            solved = true;
        }
        if (!solved && s2.equals("j") && this.hasDiphone(s1 + "-i:")) {
            p2.setSymbol("i:");
            phones.add(p1);
            phones.add(p2);
            solved = true;
        }
        if (!solved && s2.equals("N") && this.hasDiphone(s1 + "-g") && this.hasDiphone("g-N")) {
            phones.add(p1);
            phones.add(new MBROLAPhoneme("g", 10, null, null));
            phones.add(p2);
            solved = true;
        }
        if (!solved && (s1.equals("9") || s1.equals("O")) && this.hasDiphone(s1 + "-6") && this.hasDiphone("6-" + s2)) {
            phones.add(p1);
            phones.add(new MBROLAPhoneme("6", 10, null, null));
            phones.add(p2);
            solved = true;
        }
        if (!solved && this.hasDiphone(s1 + "-@") && this.hasDiphone("@-" + s2)) {
            phones.add(p1);
            phones.add(new MBROLAPhoneme("@", 10, null, null));
            phones.add(p2);
            solved = true;
        }
        if (!solved) {
            phones.add(p1);
            phones.add(p2);
        }
        return phones;
    }
}

