/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetData
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_EXAMPLE_INDEX = "example_index";
    public static final String PARAMETER_VALUE = "value";

    public SetData(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String value = this.getParameterAsString(PARAMETER_VALUE);
        int exampleIndex = this.getParameterAsInt(PARAMETER_EXAMPLE_INDEX);
        if (exampleIndex == 0) {
            throw new UserError((Operator)this, 207, "0", PARAMETER_EXAMPLE_INDEX, "only positive or negative indices are allowed");
        }
        exampleIndex = exampleIndex < 0 ? exampleSet.size() + exampleIndex : --exampleIndex;
        if (exampleIndex >= exampleSet.size()) {
            throw new UserError((Operator)this, 110, exampleIndex);
        }
        Attribute attribute = exampleSet.getAttributes().get(this.getParameter(PARAMETER_ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        }
        Example example = exampleSet.getExample(exampleIndex);
        if (attribute.isNominal()) {
            example.setValue(attribute, attribute.getMapping().mapString(value));
        } else {
            try {
                double doubleValue = Double.parseDouble(value);
                example.setValue(attribute, doubleValue);
            }
            catch (NumberFormatException e) {
                throw new UserError((Operator)this, 211, PARAMETER_VALUE, value);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the attribute for which the value should be set.", false));
        types.add(new ParameterTypeInt(PARAMETER_EXAMPLE_INDEX, "The index of the example for which the value should be set.", -2147483647, Integer.MAX_VALUE, false));
        types.add(new ParameterTypeString(PARAMETER_VALUE, "The value which should be set.", false));
        return types;
    }
}

