/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SplashScreen
extends JPanel {
    private static final long serialVersionUID = -1525644776910410809L;
    private static final Paint MAIN_PAINT = Color.WHITE;
    private static Image backgroundImage = null;
    private static final int MARGIN = 10;
    private static final String PROPERTY_FILE = "splash_infos.properties";
    private transient Image productLogo;
    private Properties properties;
    private JFrame splashScreenFrame = new JFrame();
    private String message = "Starting...";
    private boolean infosVisible;

    static {
        try {
            URL url = Tools.getResource("splashscreen_background.png");
            if (url != null) {
                backgroundImage = ImageIO.read(url);
            }
        }
        catch (IOException e) {
            LogService.getGlobal().logWarning("Cannot load images for splash screen. Using empty splash screen...");
        }
    }

    public SplashScreen(String productVersion, Image productLogo) {
        this(productLogo, SplashScreen.createDefaultProperties(productVersion));
    }

    public SplashScreen(String productVersion, Image productLogo, URL propertyFile) {
        this(productLogo, SplashScreen.createProperties(productVersion, propertyFile));
    }

    public SplashScreen(Image productLogo, Properties properties) {
        this.properties = properties;
        this.productLogo = productLogo;
        this.splashScreenFrame = new JFrame(properties.getProperty("name"));
        this.splashScreenFrame.getContentPane().add(this);
        SwingTools.setFrameIcon(this.splashScreenFrame);
        this.splashScreenFrame.setUndecorated(true);
        if (backgroundImage != null) {
            this.splashScreenFrame.setSize(backgroundImage.getWidth(this), backgroundImage.getHeight(this));
        } else {
            this.splashScreenFrame.setSize(450, 350);
        }
        this.splashScreenFrame.setLocationRelativeTo(null);
    }

    private static Properties createDefaultProperties(String productVersion) {
        return SplashScreen.createProperties(productVersion, Tools.getResource(PROPERTY_FILE));
    }

    private static Properties createProperties(String productVersion, URL propertyFile) {
        Properties properties = new Properties();
        if (propertyFile != null) {
            try {
                InputStream in = propertyFile.openStream();
                properties.load(in);
                in.close();
            }
            catch (Exception e) {
                LogService.getGlobal().logError("Cannot read splash screen infos: " + e.getMessage());
            }
        }
        properties.setProperty("version", productVersion);
        return properties;
    }

    public void showSplashScreen() {
        this.splashScreenFrame.setVisible(true);
    }

    public JFrame getSplashScreenFrame() {
        return this.splashScreenFrame;
    }

    public void dispose() {
        this.splashScreenFrame.dispose();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.drawMain((Graphics2D)g);
    }

    public void drawMain(Graphics2D g) {
        g.setPaint(MAIN_PAINT);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (backgroundImage != null) {
            g.drawImage(backgroundImage, 0, 0, this);
        }
        if (this.productLogo != null) {
            g.drawImage(this.productLogo, this.getWidth() / 2 - this.productLogo.getWidth(this) / 2, 90, this);
        }
        g.setColor(SwingTools.BROWN_FONT_COLOR);
        if (this.message != null) {
            g.setFont(new Font("SansSerif", 1, 11));
            this.drawString(g, this.message, 255);
        }
        if (this.infosVisible) {
            g.setFont(new Font("SansSerif", 0, 10));
            this.drawString(g, String.valueOf(this.properties.getProperty("name")) + " " + this.properties.getProperty("version"), 275);
            this.drawString(g, this.properties.getProperty("license"), 290);
            this.drawString(g, this.properties.getProperty("warranty"), 305);
            this.drawString(g, this.properties.getProperty("copyright"), 320);
            this.drawString(g, this.properties.getProperty("more"), 335);
        }
    }

    private void drawString(Graphics2D g, String text, int height) {
        if (text == null) {
            return;
        }
        Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(text, g);
        float xPos = (float)((double)(this.getWidth() - 10) - stringBounds.getWidth());
        float yPos = height;
        g.drawString(text, xPos, yPos);
    }

    public void setMessage(String message) {
        this.message = message;
        this.repaint();
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        this.repaint();
    }

    public void setInfosVisible(boolean b) {
        this.infosVisible = b;
        this.repaint();
    }
}

