/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.rvm;

import Jama.Matrix;
import com.rapidminer.operator.learner.functions.kernel.rvm.Model;
import com.rapidminer.operator.learner.functions.kernel.rvm.Parameter;
import com.rapidminer.operator.learner.functions.kernel.rvm.RVMBase;
import com.rapidminer.operator.learner.functions.kernel.rvm.RegressionProblem;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelBasisFunction;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelRadial;
import com.rapidminer.operator.learner.functions.kernel.rvm.util.SECholeskyDecomposition;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructiveRegression
extends RVMBase {
    protected double[][] x;
    protected double[][] t;
    protected double[] tVector;
    protected double[][] phi;
    protected Matrix PHI_t;
    protected double[] alpha;
    protected double beta;
    protected Matrix A;
    protected Matrix SIGMA;
    protected Matrix SIGMA_chol;
    protected Matrix mu;
    protected double s;
    protected double q;
    protected LinkedList<Integer> basisSet = new LinkedList();

    public ConstructiveRegression(RegressionProblem problem, Parameter parameter) {
        super(problem, parameter);
    }

    protected double[] convertListToDoubleArray(List list) {
        double[] array = new double[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (Double)list.get(i);
            ++i;
        }
        return array;
    }

    protected double innerProduct(double[] x, double[] y) {
        double sum = 0.0;
        int i = 0;
        while (i < x.length) {
            sum += x[i] * y[i];
            ++i;
        }
        return sum;
    }

    protected void prune(LinkedList<Integer> basisSet) {
        double[][] PHI_t_Array = new double[basisSet.size()][];
        int j = 0;
        while (j < basisSet.size()) {
            PHI_t_Array[j] = this.phi[basisSet.get(j)];
            ++j;
        }
        this.PHI_t = new Matrix(PHI_t_Array);
        this.A = new Matrix(basisSet.size(), basisSet.size());
        j = 0;
        while (j < basisSet.size()) {
            this.A.set(j, j, this.alpha[basisSet.get(j)]);
            ++j;
        }
    }

    protected void updateSIGMA() {
        Matrix SIGMA_inv = this.PHI_t.times(this.PHI_t.transpose());
        SIGMA_inv.timesEquals(this.beta);
        SIGMA_inv.plusEquals(this.A);
        SECholeskyDecomposition CD = new SECholeskyDecomposition(SIGMA_inv.getArray());
        Matrix U = CD.getPTR().times(CD.getL());
        this.SIGMA_chol = U.inverse();
        this.SIGMA = this.SIGMA_chol.transpose().times(this.SIGMA_chol);
    }

    protected void updateMu() {
        this.mu = this.SIGMA.times(this.PHI_t.times(new Matrix(this.t)));
        this.mu.timesEquals(this.beta);
    }

    protected void updateCriteriumScalars(int selectedBasis) {
        Matrix SigmaStuff = this.PHI_t.transpose().times(this.SIGMA.times(this.PHI_t));
        double S = this.beta * this.innerProduct(this.phi[selectedBasis], this.phi[selectedBasis]) - this.beta * this.beta * this.innerProduct(this.phi[selectedBasis], SigmaStuff.times(new Matrix(this.phi[selectedBasis], this.phi[selectedBasis].length)).getRowPackedCopy());
        double Q = this.beta * this.innerProduct(this.phi[selectedBasis], this.tVector) - this.beta * this.beta * this.innerProduct(this.phi[selectedBasis], SigmaStuff.times(new Matrix(this.t)).getRowPackedCopy());
        this.s = this.alpha[selectedBasis] * S / (this.alpha[selectedBasis] - S);
        this.q = this.alpha[selectedBasis] * Q / (this.alpha[selectedBasis] - S);
    }

    protected void reestimateAlpha(int selectedBasis) {
        this.alpha[selectedBasis] = this.s * this.s / (this.q * this.q - this.s);
    }

    protected void includeBasis(int selectedBasis) {
        this.basisSet.add(selectedBasis);
        this.reestimateAlpha(selectedBasis);
    }

    protected void deleteBasis(int selectedBasis) {
        this.basisSet.remove((Object)selectedBasis);
        this.alpha[selectedBasis] = -1.0;
    }

    protected void updateBeta() {
        double[] gammas = new double[this.basisSet.size()];
        int j = 0;
        while (j < this.basisSet.size()) {
            gammas[j] = 1.0 - this.alpha[this.basisSet.get(j)] * this.SIGMA.get(j, j);
            ++j;
        }
        double sumGammas = 0.0;
        int j2 = 0;
        while (j2 < gammas.length) {
            sumGammas += gammas[j2];
            ++j2;
        }
        Matrix DELTA = new Matrix(this.t).minus(this.PHI_t.transpose().times(this.mu));
        this.beta = (double)this.x.length - sumGammas / this.innerProduct(DELTA.getRowPackedCopy(), DELTA.getRowPackedCopy());
    }

    @Override
    public Model learn() {
        int i;
        RegressionProblem problem = (RegressionProblem)this.problem;
        int numExamples = problem.getProblemSize();
        int numBases = numExamples + 1;
        this.beta = Math.pow(0.5, -2.0);
        this.x = problem.getInputVectors();
        KernelBasisFunction[] kernels = problem.getKernels();
        this.phi = new double[numBases][numExamples];
        int j = 0;
        while (j < numBases - 1) {
            i = 0;
            while (i < numExamples) {
                this.phi[j + 1][i] = kernels[j + 1].eval(this.x[i]);
                ++i;
            }
            ++j;
        }
        i = 0;
        while (i < numExamples) {
            this.phi[0][i] = 1.0;
            ++i;
        }
        this.t = problem.getTargetVectors();
        this.tVector = new double[this.t.length];
        i = 0;
        while (i < this.t.length) {
            this.tVector[i] = this.t[i][0];
            ++i;
        }
        this.alpha = new double[numBases];
        i = 0;
        while (i < this.alpha.length) {
            this.alpha[i] = -1.0;
            ++i;
        }
        int selectedBasis = RandomGenerator.getRandomGenerator(0).nextInt(numBases);
        this.basisSet.add(selectedBasis);
        double normPhiSquare = this.innerProduct(this.phi[selectedBasis], this.phi[selectedBasis]);
        this.alpha[selectedBasis] = normPhiSquare / (this.innerProduct(this.phi[selectedBasis], this.tVector) / normPhiSquare - 1.0 / this.beta);
        i = 1;
        while (i <= this.parameter.maxIterations) {
            double[] logAlphas = new double[this.alpha.length];
            j = 0;
            while (j < logAlphas.length) {
                double value = Math.log(this.alpha[j]);
                if (Double.isNaN(value)) {
                    value = 0.0;
                }
                logAlphas[j] = value;
                ++j;
            }
            this.prune(this.basisSet);
            this.updateSIGMA();
            this.updateMu();
            this.updateBeta();
            selectedBasis = i % numBases;
            this.updateCriteriumScalars(selectedBasis);
            double theta = this.q * this.q - this.s;
            if (theta > 0.0) {
                if (this.alpha[selectedBasis] > 0.0) {
                    this.reestimateAlpha(selectedBasis);
                } else {
                    this.includeBasis(selectedBasis);
                }
            } else if (this.alpha[selectedBasis] > 0.0) {
                this.deleteBasis(selectedBasis);
            }
            double maxLogAlphaChange = 0.0;
            j = 0;
            while (j < logAlphas.length) {
                double change;
                double newValue = Math.log(this.alpha[j]);
                if (Double.isNaN(newValue)) {
                    newValue = 0.0;
                }
                if ((change = Math.abs(logAlphas[j] - newValue)) > maxLogAlphaChange) {
                    maxLogAlphaChange = change;
                }
                ++j;
            }
            if (Tools.isNotEqual(maxLogAlphaChange, 0.0) && maxLogAlphaChange < this.parameter.min_delta_log_alpha) break;
            ++i;
        }
        double[] finalWeights = new double[this.basisSet.size()];
        KernelBasisFunction[] finalKernels = new KernelBasisFunction[this.basisSet.size()];
        boolean bias = false;
        j = 0;
        while (j < this.basisSet.size()) {
            finalWeights[j] = this.mu.get(j, 0);
            if (this.basisSet.get(j) == 0) {
                bias = true;
                finalKernels[j] = new KernelBasisFunction(new KernelRadial());
            } else {
                finalKernels[j] = kernels[this.basisSet.get(j)];
            }
            ++j;
        }
        Model model = new Model(finalWeights, finalKernels, bias, true);
        return model;
    }

    public String toString() {
        return "Constructive-Regression-RVM";
    }
}

