/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.meta.WeightedPerformanceMeasures;
import com.rapidminer.tools.Tools;
import java.util.Iterator;

public class SDReweightMeasures
extends WeightedPerformanceMeasures {
    private double gamma;
    private boolean additive = true;

    public SDReweightMeasures(ExampleSet e) throws OperatorException {
        super(e);
    }

    public boolean reweightExamples(ExampleSet exampleSet, int posIndex, int coveredSubset) throws OperatorException {
        Iterator reader = exampleSet.iterator();
        Attribute timesCoveredAttrib = null;
        if (this.additive) {
            timesCoveredAttrib = exampleSet.getAttributes().get("TIMES_COVERED_SPECIAL_ATTRIB");
        }
        double sumPosWeight = 0.0;
        double sumNegWeight = 0.0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            double weight = example.getWeight();
            int label = (int)example.getLabel();
            if (label == posIndex) {
                int predicted = (int)example.getPredictedLabel();
                if (predicted == coveredSubset) {
                    if (this.additive) {
                        int timesCovered = (int)example.getValue(timesCoveredAttrib) + 1;
                        weight = this.reweightAdd(weight, timesCovered);
                        example.setValue(timesCoveredAttrib, timesCovered);
                    } else {
                        weight = this.reweightMult(weight);
                    }
                    example.setWeight(weight);
                }
                sumPosWeight += weight;
                continue;
            }
            sumNegWeight += weight;
        }
        double ratio = sumPosWeight / sumNegWeight;
        if (Tools.isNotEqual(ratio, 1.0)) {
            for (Example example : exampleSet) {
                if ((int)example.getLabel() == posIndex) continue;
                example.setWeight(example.getWeight() * ratio);
            }
        }
        return true;
    }

    private double reweightAdd(double w, int timesCovered) {
        return w * (double)timesCovered / (double)(timesCovered + 1);
    }

    private double reweightMult(double w) {
        return w * this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }
}

