/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.jsapi;

import com.sun.speech.freetts.ValidationException;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import com.sun.speech.freetts.jsapi.DomainLocale;
import com.sun.speech.freetts.jsapi.FreeTTSSynthesizerModeDesc;
import com.sun.speech.freetts.jsapi.FreeTTSVoice;
import java.util.Vector;
import javax.speech.EngineCentral;
import javax.speech.EngineList;
import javax.speech.EngineModeDesc;

public class FreeTTSEngineCentral
implements EngineCentral {
    private String engineName = "FreeTTS Synthesizer";

    public EngineList createEngineList(EngineModeDesc require) {
        DomainLocale dl;
        int i;
        EngineList el = new EngineList();
        VoiceManager voiceManager = VoiceManager.getInstance();
        Voice[] voices = voiceManager.getVoices();
        Vector<DomainLocale> domainLocaleVector = new Vector<DomainLocale>();
        for (i = 0; i < voices.length; ++i) {
            dl = new DomainLocale(voices[i].getDomain(), voices[i].getLocale());
            DomainLocale dlentry = (DomainLocale)this.getItem(domainLocaleVector, dl);
            if (dlentry == null) {
                domainLocaleVector.add(dl);
                dlentry = dl;
            }
            dlentry.addVoice(voices[i]);
        }
        for (i = 0; i < domainLocaleVector.size(); ++i) {
            dl = (DomainLocale)domainLocaleVector.get(i);
            FreeTTSSynthesizerModeDesc desc = new FreeTTSSynthesizerModeDesc("FreeTTS " + dl.getLocale().toString() + " " + dl.getDomain() + " synthesizer", dl.getDomain(), dl.getLocale());
            voices = dl.getVoices();
            for (int j = 0; j < voices.length; ++j) {
                FreeTTSVoice jsapiVoice = new FreeTTSVoice(voices[j], null);
                desc.addVoice(jsapiVoice);
            }
            if (require != null && !desc.match(require)) continue;
            try {
                desc.validate();
                el.addElement((Object)desc);
                continue;
            }
            catch (ValidationException ve) {
                System.err.println(ve.getMessage());
            }
        }
        if (el.size() == 0) {
            el = null;
        }
        return el;
    }

    private Object getItem(Vector vector, Object o) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.get(i).equals(o)) continue;
            return vector.get(i);
        }
        return null;
    }
}

