/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

public class StringPattern {
    private static int INITAL_CAPITAL_LETTER = 1;
    private static int ALL_CAPITAL_LETTER = 2;
    private static int ALL_LOWERCASE_LETTER = 4;
    private static int ALL_LETTERS = 8;
    private static int ALL_DIGIT = 16;
    private static int CONTAINS_PERIOD = 32;
    private static int CONTAINS_COMMA = 64;
    private static int CONTAINS_SLASH = 128;
    private static int CONTAINS_DIGIT = 256;
    private static int CONTAINS_HYPHEN = 512;
    private static int CONTAINS_LETTERS = 1024;
    private static int CONTAINS_UPPERCASE = 2048;
    private final int pattern;
    private final int digits;

    private StringPattern(int pattern, int digits) {
        this.pattern = pattern;
        this.digits = digits;
    }

    public boolean isInitialCapitalLetter() {
        return (this.pattern & INITAL_CAPITAL_LETTER) > 0;
    }

    public boolean isAllCapitalLetter() {
        return (this.pattern & ALL_CAPITAL_LETTER) > 0;
    }

    public boolean isAllLowerCaseLetter() {
        return (this.pattern & ALL_LOWERCASE_LETTER) > 0;
    }

    public boolean isAllDigit() {
        return (this.pattern & ALL_DIGIT) > 0;
    }

    public int digits() {
        return this.digits;
    }

    public boolean containsPeriod() {
        return (this.pattern & CONTAINS_PERIOD) > 0;
    }

    public boolean containsComma() {
        return (this.pattern & CONTAINS_COMMA) > 0;
    }

    public boolean containsSlash() {
        return (this.pattern & CONTAINS_SLASH) > 0;
    }

    public boolean containsDigit() {
        return (this.pattern & CONTAINS_DIGIT) > 0;
    }

    public boolean containsHyphen() {
        return (this.pattern & CONTAINS_HYPHEN) > 0;
    }

    public boolean containsLetters() {
        return (this.pattern & CONTAINS_LETTERS) > 0;
    }

    public static StringPattern recognize(String token) {
        int pattern = ALL_CAPITAL_LETTER | ALL_LOWERCASE_LETTER | ALL_DIGIT | ALL_LETTERS;
        int digits = 0;
        block6: for (int i = 0; i < token.length(); ++i) {
            boolean isLetter;
            char ch = token.charAt(i);
            int letterType = Character.getType(ch);
            boolean bl = isLetter = letterType == 1 || letterType == 2 || letterType == 3 || letterType == 4 || letterType == 5;
            if (isLetter) {
                pattern |= CONTAINS_LETTERS;
                pattern &= ~ALL_DIGIT;
                if (letterType == 1) {
                    if (i == 0) {
                        pattern |= INITAL_CAPITAL_LETTER;
                    }
                    pattern |= CONTAINS_UPPERCASE;
                    pattern &= ~ALL_LOWERCASE_LETTER;
                    continue;
                }
                pattern &= ~ALL_CAPITAL_LETTER;
                continue;
            }
            pattern &= ~ALL_LETTERS;
            pattern &= ~ALL_CAPITAL_LETTER;
            pattern &= ~ALL_LOWERCASE_LETTER;
            if (letterType == 9) {
                pattern |= CONTAINS_DIGIT;
                ++digits;
            } else {
                pattern &= ~ALL_DIGIT;
            }
            switch (ch) {
                case ',': {
                    pattern |= CONTAINS_COMMA;
                    continue block6;
                }
                case '.': {
                    pattern |= CONTAINS_PERIOD;
                    continue block6;
                }
                case '/': {
                    pattern |= CONTAINS_SLASH;
                    continue block6;
                }
                case '-': {
                    pattern |= CONTAINS_HYPHEN;
                    continue block6;
                }
            }
        }
        return new StringPattern(pattern, digits);
    }
}

