/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.util.dom.LoggingErrorHandler;
import org.w3c.dom.Document;

public class SableParser
extends InternalModule {
    private static Templates stylesheet = null;
    private DocumentBuilderFactory dbFactory = null;
    private DocumentBuilder docBuilder = null;
    private boolean doWarnClient = false;

    public SableParser() {
        super("SableParser", MaryDataType.SABLE, MaryDataType.RAWMARYXML, null);
    }

    public boolean getWarnClient() {
        return this.doWarnClient;
    }

    public void setWarnClient(boolean doWarnClient) {
        this.doWarnClient = doWarnClient;
    }

    @Override
    public void startup() throws Exception {
        this.setWarnClient(true);
        if (stylesheet == null) {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesheetStream = new StreamSource(this.getClass().getResourceAsStream("sable-to-mary.xsl"));
            stylesheet = tFactory.newTemplates(stylesheetStream);
        }
        if (this.dbFactory == null) {
            this.dbFactory = DocumentBuilderFactory.newInstance();
        }
        if (this.docBuilder == null) {
            this.docBuilder = this.dbFactory.newDocumentBuilder();
        }
        super.startup();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        DOMSource domSource = new DOMSource(d.getDocument());
        Transformer transformer = stylesheet.newTransformer();
        if (this.doWarnClient) {
            transformer.setErrorListener(new LoggingErrorHandler(Thread.currentThread().getName() + " client.Sable transformer"));
        }
        Document maryxmlDocument = this.docBuilder.newDocument();
        DOMResult domResult = new DOMResult(maryxmlDocument);
        transformer.transform(domSource, domResult);
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(maryxmlDocument);
        return result;
    }
}

