/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.MultiDisplay;
import marytts.signalproc.filter.BandRejectFilter;
import marytts.signalproc.filter.FIRFilter;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class BandPassFilter
extends FIRFilter {
    public static double DEFAULT_TRANSITIONBANDWIDTH = 0.01;
    public double lowerNormalisedCutoffFrequency;
    public double upperNormalisedCutoffFrequency;

    public BandPassFilter(double lowerNormalisedCutoffFrequencyIn, double upperNormalisedCutoffFrequencyIn) {
        this(lowerNormalisedCutoffFrequencyIn, upperNormalisedCutoffFrequencyIn, DEFAULT_TRANSITIONBANDWIDTH);
    }

    public BandPassFilter(double lowerNormalisedCutoffFrequencyIn, double upperNormalisedCutoffFrequencyIn, double normalisedTransitionBandwidth) {
        this(lowerNormalisedCutoffFrequencyIn, upperNormalisedCutoffFrequencyIn, BandPassFilter.bandwidth2kernelLength(normalisedTransitionBandwidth));
    }

    public BandPassFilter(double lowerNormalisedCutoffFrequencyIn, double upperNormalisedCutoffFrequencyIn, int kernelLength) {
        if (kernelLength <= 0 || kernelLength % 2 == 0) {
            throw new IllegalArgumentException("Kernel length must be an odd positive number, got " + kernelLength);
        }
        this.lowerNormalisedCutoffFrequency = lowerNormalisedCutoffFrequencyIn;
        this.upperNormalisedCutoffFrequency = upperNormalisedCutoffFrequencyIn;
        if (this.lowerNormalisedCutoffFrequency <= 0.0 || this.lowerNormalisedCutoffFrequency >= 0.5 || this.upperNormalisedCutoffFrequency <= 0.0 || this.upperNormalisedCutoffFrequency >= 0.5) {
            throw new IllegalArgumentException("Normalised cutoff frequencies must be between 0 and 0.5, got " + this.lowerNormalisedCutoffFrequency + " and " + this.upperNormalisedCutoffFrequency);
        }
        double[] kernel = BandPassFilter.getKernel(this.lowerNormalisedCutoffFrequency, this.upperNormalisedCutoffFrequency, kernelLength);
        this.sliceLength = MathUtils.closestPowerOfTwoAbove(2 * kernelLength) - kernelLength;
        this.initialise(kernel, this.sliceLength);
    }

    public double getTransitionBandWidth(int samplingRate) {
        return (double)samplingRate * BandPassFilter.kernelLength2bandwidth(this.impulseResponseLength);
    }

    protected static double[] getKernel(double lowerNormalisedCutoffFrequencyIn, double upperNormalisedCutoffFrequencyIn, int kernelLength) {
        double[] bandRejectKernel = BandRejectFilter.getKernel(lowerNormalisedCutoffFrequencyIn, upperNormalisedCutoffFrequencyIn, kernelLength);
        double[] kernel = new double[kernelLength];
        for (int i = 0; i < kernelLength; ++i) {
            kernel[i] = -bandRejectKernel[i];
        }
        int n = (kernelLength - 1) / 2;
        kernel[n] = kernel[n] + 1.0;
        return kernel;
    }

    protected static int bandwidth2kernelLength(double normalisedTransitionBandwidth) {
        int l = (int)(4.0 / normalisedTransitionBandwidth);
        if (l % 2 == 0) {
            ++l;
        }
        return l;
    }

    protected static double kernelLength2bandwidth(int kernelLength) {
        return 4.0 / (double)kernelLength;
    }

    public String toString() {
        return "Bandpass filter";
    }

    public static void main(String[] args) throws Exception {
        int lowerCutoffFreq = Integer.valueOf(args[0]);
        int upperCutoffFreq = Integer.valueOf(args[1]);
        AudioDoubleDataSource source = new AudioDoubleDataSource(AudioSystem.getAudioInputStream(new File(args[2])));
        int samplingRate = source.getSamplingRate();
        double lowerNormalisedCutoffFrequency = (double)lowerCutoffFreq / (double)samplingRate;
        double upperNormalisedCutoffFrequency = (double)upperCutoffFreq / (double)samplingRate;
        BandPassFilter filter = new BandPassFilter(lowerNormalisedCutoffFrequency, upperNormalisedCutoffFrequency);
        System.err.println("Created " + filter.toString() + " with reject band from " + lowerCutoffFreq + " Hz to " + upperCutoffFreq + " Hz and transition band width " + (int)filter.getTransitionBandWidth(samplingRate) + " Hz");
        double[] fftSignal = new double[filter.transformedIR.length];
        System.arraycopy(filter.transformedIR, 0, fftSignal, 0, filter.transformedIR.length);
        FFT.realTransform(fftSignal, true);
        double[] kernel = new double[filter.impulseResponseLength];
        System.arraycopy(fftSignal, 0, kernel, 0, kernel.length);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0, kernel);
        timeGraph.showInJFrame(filter.toString() + " in time domain", true, false);
        double[] powerSpectrum = FFT.computePowerSpectrum_FD(filter.transformedIR);
        for (int i = 0; i < powerSpectrum.length; ++i) {
            powerSpectrum[i] = MathUtils.db(powerSpectrum[i]);
        }
        FunctionGraph freqGraph = new FunctionGraph(0.0, (double)samplingRate / (double)filter.transformedIR.length, powerSpectrum);
        freqGraph.showInJFrame(filter.toString() + " log frequency response", true, false);
        DoubleDataSource filteredSignal = filter.apply(source);
        MultiDisplay display = new MultiDisplay(filteredSignal.getAllData(), samplingRate, filter.toString() + " (" + lowerCutoffFreq + "->" + upperCutoffFreq + "Hz) applied to " + args[2], 800, 600);
    }
}

