/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.Mean;
import opennlp.tools.util.model.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSTaggerCrossValidator {
    private final String languageCode;
    private final ModelType modelType;
    private final int cutoff;
    private final int iterations;
    private POSDictionary tagDictionary;
    private Dictionary ngramDictionary;
    private Mean wordAccuracy = new Mean();

    public POSTaggerCrossValidator(String languageCode, ModelType modelType, POSDictionary tagDictionary, Dictionary ngramDictionary, int cutoff, int iterations) {
        this.languageCode = languageCode;
        this.modelType = modelType;
        this.cutoff = cutoff;
        this.iterations = iterations;
        this.tagDictionary = tagDictionary;
        this.ngramDictionary = ngramDictionary;
    }

    public POSTaggerCrossValidator(String languageCode, ModelType modelType, POSDictionary tagDictionary, Dictionary ngramDictionary) {
        this(languageCode, modelType, tagDictionary, ngramDictionary, 5, 100);
    }

    public void evaluate(ObjectStream<POSSample> samples, int nFolds) throws IOException, IOException {
        CrossValidationPartitioner<POSSample> partitioner = new CrossValidationPartitioner<POSSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<POSSample> trainingSampleStream = partitioner.next();
            POSModel model = POSTaggerME.train(this.languageCode, trainingSampleStream, this.modelType, this.tagDictionary, this.ngramDictionary, this.cutoff, this.iterations);
            POSEvaluator evaluator = new POSEvaluator(new POSTaggerME(model));
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.wordAccuracy.add(evaluator.getWordAccuracy(), evaluator.getWordCount());
        }
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }
}

