/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class AttributeRole
implements Serializable {
    private static final long serialVersionUID = -4855352048163007173L;
    private boolean special = false;
    private String specialName = null;
    private Attribute attribute;
    private transient List<Attributes> owners = new LinkedList<Attributes>();

    public AttributeRole(Attribute attribute) {
        this.attribute = attribute;
    }

    private AttributeRole(AttributeRole other) {
        this.attribute = (Attribute)other.attribute.clone();
        this.special = other.special;
        this.specialName = other.specialName;
    }

    public Object readResolve() {
        if (this.owners == null) {
            this.owners = new LinkedList<Attributes>();
        }
        return this;
    }

    public Object clone() {
        return new AttributeRole(this);
    }

    protected void addOwner(Attributes attributes) {
        this.owners.add(attributes);
    }

    protected void removeOwner(Attributes attributes) {
        this.owners.remove(attributes);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public String getSpecialName() {
        return this.specialName;
    }

    public void setSpecial(String specialName) {
        for (Attributes attributes : this.owners) {
            attributes.rename(this, specialName);
        }
        this.specialName = specialName;
        this.special = specialName != null;
    }

    public void changeToRegular() {
        this.setSpecial(null);
    }

    public String toString() {
        if (this.isSpecial()) {
            return String.valueOf(this.specialName) + " := " + this.attribute.getName();
        }
        return this.attribute.getName();
    }
}

