/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.att.AttributeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExampleTable
implements ExampleTable {
    private static final long serialVersionUID = -6996954528182122684L;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<Integer> unusedColumnList = new LinkedList<Integer>();

    public AbstractExampleTable(List<Attribute> attributes) {
        this.addAttributes(attributes);
    }

    @Override
    public Attribute[] getAttributes() {
        Attribute[] attribute = new Attribute[this.attributes.size()];
        this.attributes.toArray(attribute);
        return attribute;
    }

    @Override
    public Attribute getAttribute(int i) {
        return this.attributes.get(i);
    }

    @Override
    public Attribute findAttribute(String name) throws OperatorException {
        if (name == null) {
            return null;
        }
        for (Attribute att : this.attributes) {
            if (att == null || !att.getName().equals(name)) continue;
            return att;
        }
        throw new UserError(null, 111, name);
    }

    @Override
    public void addAttributes(Collection<Attribute> newAttributes) {
        Iterator<Attribute> i = newAttributes.iterator();
        while (i.hasNext()) {
            this.addAttribute(i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAttribute(Attribute a) {
        int index = -1;
        if (this.unusedColumnList.size() > 0) {
            List<Integer> list = this.unusedColumnList;
            synchronized (list) {
                if (this.unusedColumnList.size() > 0) {
                    index = this.unusedColumnList.remove(0);
                    this.attributes.set(index, a);
                } else {
                    index = this.attributes.size();
                    this.attributes.add(a);
                }
            }
        } else {
            index = this.attributes.size();
            this.attributes.add(a);
        }
        if (a != null) {
            a.setTableIndex(index);
        }
        return index;
    }

    @Override
    public void removeAttribute(Attribute attribute) {
        this.removeAttribute(attribute.getTableIndex());
    }

    @Override
    public synchronized void removeAttribute(int index) {
        Attribute a = this.attributes.get(index);
        if (a == null) {
            return;
        }
        this.attributes.set(index, null);
        this.unusedColumnList.add(index);
    }

    @Override
    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size() - this.unusedColumnList.size();
    }

    @Override
    public ExampleSet createExampleSet(Attribute labelAttribute) {
        return this.createExampleSet(labelAttribute, null, null);
    }

    @Override
    public ExampleSet createExampleSet(Attribute labelAttribute, Attribute weightAttribute, Attribute idAttribute) {
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        if (labelAttribute != null) {
            specialAttributes.put(labelAttribute, "label");
        }
        if (weightAttribute != null) {
            specialAttributes.put(weightAttribute, "weight");
        }
        if (idAttribute != null) {
            specialAttributes.put(idAttribute, "id");
        }
        return new SimpleExampleSet((ExampleTable)this, specialAttributes);
    }

    @Override
    public ExampleSet createExampleSet(Iterator<AttributeRole> newSpecialAttributes) {
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        while (newSpecialAttributes.hasNext()) {
            AttributeRole role = newSpecialAttributes.next();
            specialAttributes.put(role.getAttribute(), role.getSpecialName());
        }
        return new SimpleExampleSet((ExampleTable)this, specialAttributes);
    }

    @Override
    public ExampleSet createExampleSet(AttributeSet attributeSet) {
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        for (String name : attributeSet.getSpecialNames()) {
            specialAttributes.put(attributeSet.getSpecialAttribute(name), name);
        }
        return this.createExampleSet(specialAttributes);
    }

    @Override
    public ExampleSet createExampleSet() {
        return this.createExampleSet(new HashMap<Attribute, String>());
    }

    @Override
    public ExampleSet createExampleSet(Map<Attribute, String> specialAttributes) {
        return new SimpleExampleSet((ExampleTable)this, specialAttributes);
    }

    @Override
    public String toString() {
        return "ExampleTable, " + this.attributes.size() + " attributes, " + this.size() + " data rows," + Tools.getLineSeparator() + "attributes: " + this.attributes;
    }

    @Override
    public String toDataString() {
        StringBuffer result = new StringBuffer(String.valueOf(this.toString()) + Tools.getLineSeparator());
        DataRowReader reader = this.getDataRowReader();
        while (reader.hasNext()) {
            result.append(String.valueOf(((DataRow)reader.next()).toString()) + Tools.getLineSeparator());
        }
        return result.toString();
    }
}

