/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.tools.LogService;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryNumericalGenerator
extends FeatureGenerator {
    private static final Attribute[] INPUT_ATTR = new Attribute[]{AttributeFactory.createAttribute(2), AttributeFactory.createAttribute(2)};

    public abstract double calculateValue(double var1, double var3);

    public abstract boolean isCommutative();

    public abstract boolean isSelfApplicable();

    @Override
    public Attribute[] getInputAttributes() {
        return INPUT_ATTR;
    }

    @Override
    public Attribute[] getOutputAttributes(ExampleTable input) {
        String construction2;
        Attribute a1 = this.getArgument(0);
        Attribute a2 = this.getArgument(1);
        String construction1 = a1.getConstruction();
        if (!(construction1.equals(a1.getName()) || construction1.startsWith("(") || construction1.endsWith(")"))) {
            construction1 = "(" + construction1 + ")";
        }
        if (!((construction2 = a2.getConstruction()).equals(a2.getName()) || construction2.startsWith("(") || construction2.endsWith(")"))) {
            construction2 = "(" + construction2 + ")";
        }
        Attribute ao = AttributeFactory.createAttribute(4, 1, "(" + construction1 + " " + this.getFunction() + " " + construction2 + ")");
        return new Attribute[]{ao};
    }

    @Override
    public List<Attribute[]> getInputCandidates(ExampleSet exampleSet, String[] functions) {
        ArrayList<Attribute[]> result;
        block14: {
            block17: {
                block16: {
                    block15: {
                        block13: {
                            result = new ArrayList<Attribute[]>();
                            if (BinaryNumericalGenerator.getSelectionMode() != 0) break block13;
                            for (Attribute first : exampleSet.getAttributes()) {
                                if (!this.checkCompatibility(first, INPUT_ATTR[0], functions)) continue;
                                for (Attribute second : exampleSet.getAttributes()) {
                                    if (!this.checkCompatibility(second, INPUT_ATTR[1], functions)) continue;
                                    result.add(new Attribute[]{first, second});
                                }
                            }
                            break block14;
                        }
                        if (!this.isCommutative() || !this.isSelfApplicable()) break block15;
                        int firstCounter = 0;
                        for (Attribute first : exampleSet.getAttributes()) {
                            if (!this.checkCompatibility(first, INPUT_ATTR[0], functions)) continue;
                            int secondCounter = 0;
                            for (Attribute second : exampleSet.getAttributes()) {
                                if (secondCounter >= firstCounter && this.checkCompatibility(second, INPUT_ATTR[1], functions)) {
                                    result.add(new Attribute[]{first, second});
                                }
                                ++secondCounter;
                            }
                            ++firstCounter;
                        }
                        break block14;
                    }
                    if (!this.isCommutative() || this.isSelfApplicable()) break block16;
                    int firstCounter = 0;
                    for (Attribute first : exampleSet.getAttributes()) {
                        if (!this.checkCompatibility(first, INPUT_ATTR[0], functions)) continue;
                        int secondCounter = 0;
                        for (Attribute second : exampleSet.getAttributes()) {
                            if (secondCounter > firstCounter && this.checkCompatibility(second, INPUT_ATTR[1], functions)) {
                                result.add(new Attribute[]{first, second});
                            }
                            ++secondCounter;
                        }
                        ++firstCounter;
                    }
                    break block14;
                }
                if (this.isCommutative() || !this.isSelfApplicable()) break block17;
                for (Attribute first : exampleSet.getAttributes()) {
                    if (!this.checkCompatibility(first, INPUT_ATTR[0], functions)) continue;
                    for (Attribute second : exampleSet.getAttributes()) {
                        if (!this.checkCompatibility(second, INPUT_ATTR[1], functions)) continue;
                        result.add(new Attribute[]{first, second});
                    }
                }
                break block14;
            }
            if (this.isCommutative() || this.isSelfApplicable()) break block14;
            int firstCounter = 0;
            for (Attribute first : exampleSet.getAttributes()) {
                if (!this.checkCompatibility(first, INPUT_ATTR[0], functions)) continue;
                int secondCounter = 0;
                for (Attribute second : exampleSet.getAttributes()) {
                    if (firstCounter != secondCounter && this.checkCompatibility(second, INPUT_ATTR[1], functions)) {
                        result.add(new Attribute[]{first, second});
                    }
                    ++secondCounter;
                }
                ++firstCounter;
            }
        }
        return result;
    }

    @Override
    public void generate(DataRow data) throws GenerationException {
        try {
            Attribute a0 = this.getArgument(0);
            Attribute a1 = this.getArgument(1);
            double o1 = data.get(a0);
            double o2 = data.get(a1);
            double r = this.calculateValue(o1, o2);
            if (Double.isInfinite(r)) {
                LogService.getGlobal().log(String.valueOf(this.getFunction()) + ": Infinite value generated.", 5);
            }
            if (Double.isNaN(r)) {
                LogService.getGlobal().log(String.valueOf(this.getFunction()) + ": NaN generated.", 5);
            }
            if (this.resultAttributes[0] != null) {
                data.set(this.resultAttributes[0], r);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GenerationException("a1:" + this.getArgument(0) + " a2: " + this.getArgument(1), ex);
        }
    }

    @Override
    public String toString() {
        String s = "binary function (";
        if (this.resultAttributes != null && this.resultAttributes.length > 0 && this.resultAttributes[0] != null) {
            s = String.valueOf(s) + this.resultAttributes[0].getName() + ":=";
        }
        if (this.argumentsSet()) {
            s = String.valueOf(s) + this.getArgument(0).getName() + " ";
        }
        s = String.valueOf(s) + this.getFunction();
        if (this.argumentsSet()) {
            s = String.valueOf(s) + " " + this.getArgument(1).getName();
        }
        s = String.valueOf(s) + ")";
        return s;
    }
}

