/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.utility;

import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.igss.utility.AbstractUtility;
import com.rapidminer.operator.learner.igss.utility.Coverage;

public class Squared
extends AbstractUtility {
    public Squared(double[] priors, int large) {
        super(priors, large);
    }

    public double utility(double totalWeight, double totalPositiveWeight, Hypothesis hypo) {
        double g = hypo.getCoveredWeight() / totalWeight;
        double p = hypo.getPositiveWeight() / hypo.getCoveredWeight();
        if (hypo.getPrediction() == 1) {
            return g * g * (p - this.priors[1]);
        }
        return g * g * (p - this.priors[0]);
    }

    public double conf(double totalWeight, double delta) {
        double inverseNormal = this.inverseNormal(1.0 - delta / 2.0);
        return 3.0 / (2.0 * Math.sqrt(totalWeight)) * inverseNormal + (totalWeight + Math.sqrt(totalWeight)) / (4.0 * totalWeight * Math.sqrt(totalWeight)) * Math.pow(inverseNormal, 2.0) + Math.pow(inverseNormal, 3.0) / (8.0 * totalWeight * Math.sqrt(totalWeight));
    }

    public double conf(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        double g = hypo.getCoveredWeight() / totalWeight;
        double p = hypo.getPositiveWeight() / hypo.getCoveredWeight();
        double sg = this.variance(g, totalWeight);
        double sp = this.variance(p, hypo.getCoveredWeight());
        double inverseNormal = this.inverseNormal(1.0 - delta / 2.0);
        return 2.0 * sg * inverseNormal + sg * sg * Math.pow(inverseNormal, 2.0) + sp * inverseNormal + 2.0 * sg * sp * Math.pow(inverseNormal, 2.0) + sp * sg * sg * Math.pow(inverseNormal, 3.0);
    }

    private double variance(double p, double totalWeight) {
        return p * (1.0 - p) / totalWeight;
    }

    public double confSmallM(double totalWeight, double delta) {
        double term = Math.log(4.0 / delta) / (2.0 * totalWeight);
        return Math.pow(term, 1.5) + 3.0 * term + 3.0 * Math.sqrt(term);
    }

    public double getUpperBound(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        double p0 = hypo.getPrediction() == 1 ? this.priors[1] : this.priors[0];
        Coverage cov = new Coverage(this.priors, this.large);
        Hypothesis h = hypo.clone();
        h.setCoveredWeight(hypo.getPositiveWeight());
        double g = cov.utility(totalWeight, totalPositiveWeight, h);
        double conf = cov.confidenceIntervall(totalWeight, delta);
        return (g + conf) * (g + conf) * (1.0 - p0);
    }
}

