/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeAdd
extends AbstractDataProcessing {
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_VALUE_TYPE = "value_type";

    public AttributeAdd(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String name = this.getParameterAsString(PARAMETER_NAME);
        int valueType = this.getParameterAsInt(PARAMETER_VALUE_TYPE);
        Attribute attribute = AttributeFactory.createAttribute(name, valueType);
        exampleSet.getExampleTable().addAttribute(attribute);
        exampleSet.getAttributes().addRegular(attribute);
        for (Example example : exampleSet) {
            example.setValue(attribute, Double.NaN);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_NAME, "The name of the new attribute.", false));
        types.add(new ParameterTypeCategory(PARAMETER_VALUE_TYPE, "The value type of the new attribute.", Ontology.VALUE_TYPE_NAMES, 4));
        return types;
    }
}

